/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.ChildNameGenerator;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.EventOutputStreams;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.cloudbees.hudson.plugins.folder.views.AbstractFolderViewHolder;
import com.thoughtworks.xstream.XStreamException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.XmlFile;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.SaveableListener;
import hudson.scm.PollingResult;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.PersistedList;
import hudson.util.StreamTaskListener;
import hudson.util.XStream2;
import jakarta.servlet.ServletException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.branch.Branch;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchEventCause;
import jenkins.branch.BranchIndexingCause;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchSource;
import jenkins.branch.Messages;
import jenkins.branch.MetadataActionFolderIcon;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.branch.MultiBranchProjectDisplayNamingStrategy;
import jenkins.branch.MultiBranchProjectDisplayNamingTrait;
import jenkins.branch.MultiBranchProjectEmptyView;
import jenkins.branch.MultiBranchProjectViewHolder;
import jenkins.branch.NameEncoder;
import jenkins.branch.PropertyMigration;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.TransientActionFactory;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMEventListener;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadMigration;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.mixin.TagSCMHead;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.impl.NullSCMSource;
import jenkins.triggers.SCMTriggerItem;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.springframework.security.core.Authentication;

public abstract class MultiBranchProject<P extends Job<P, R>, R extends Run<P, R>>
extends ComputedFolder<P>
implements SCMSourceOwner,
IconSpec {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    private static boolean FIRE_SCM_SOURCE_BUILDS_AFTER_SAVE = SystemProperties.getBoolean((String)(MultiBranchProject.class.getName() + ".fireSCMSourceBuildsAfterSave"), (boolean)true);
    private static final Logger LOGGER = Logger.getLogger(MultiBranchProject.class.getName());
    private PersistedList<BranchSource> sources = new BranchSourceList(this);
    private transient State state = new State(this);
    private transient NullSCMSource nullSCMSource;
    private volatile BranchProjectFactory<P, R> factory;
    private transient String srcDigest;
    private transient String facDigest;
    private static final XStream2 SOURCE_ID_OMITTED_XSTREAM = new XStream2();
    private static final Set<Permission> SUPPRESSED_PERMISSIONS;

    protected MultiBranchProject(ItemGroup parent, String name) {
        super(parent, name);
        this.init2();
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.init2();
        PropertyMigration.applyAll(this);
        try {
            this.srcDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.sources));
        }
        catch (XStreamException e) {
            this.srcDigest = null;
        }
        BranchProjectFactory factory = this.getProjectFactory();
        try {
            this.facDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(factory));
        }
        catch (XStreamException e) {
            this.facDigest = null;
        }
        if (this.state == null) {
            this.state = new State(this);
        }
        try {
            this.state.load();
        }
        catch (XStreamException | IOException e) {
            LOGGER.log(Level.WARNING, "Could not read persisted state, will be recovered on next index.", e);
            this.state.reset();
        }
        HashMap<String, SCMSource> sourceMap = new HashMap<String, SCMSource>();
        for (BranchSource source : this.sources) {
            SCMSource s = source.getSource();
            String id = s.getId();
            if (sourceMap.containsKey(id)) continue;
            sourceMap.put(id, s);
        }
        for (Job item : this.getItems(x$0 -> factory.isProject((Item)x$0))) {
            SCMHead oldHead;
            SCMHead newHead;
            Branch oldBranch = factory.getBranch(item);
            SCMSource source = (SCMSource)sourceMap.get(oldBranch.getSourceId());
            if (source == null || source instanceof NullSCMSource || (newHead = SCMHeadMigration.readResolveSCMHead((SCMSource)source, (SCMHead)(oldHead = oldBranch.getHead()))) == oldHead) continue;
            LOGGER.log(Level.INFO, "Job {0}: a plugin upgrade is requesting migration of branch from {1} to {2}", new Object[]{item.getFullName(), oldHead.getClass(), newHead.getClass()});
            try {
                Branch newBranch = new Branch(oldBranch.getSourceId(), newHead, oldBranch.getScm(), oldBranch.getProperties());
                newBranch.setActions(oldBranch.getActions());
                factory.setBranch(item, newBranch);
                SCMRevision revision = factory.getRevision(item);
                factory.setRevisionHash(item, SCMHeadMigration.readResolveSCMRevision((SCMSource)source, (SCMRevision)revision));
            }
            catch (IOException | RuntimeException e) {
                LogRecord lr = new LogRecord(Level.WARNING, "Job {0}: Could not complete migration of branch from type {1} to {2}. The side-effect of this is that the next index may trigger a rebuild of the job (after which the issue will be resolved)");
                lr.setThrown(e);
                lr.setParameters(new Object[]{item.getFullName(), oldHead.getClass(), newHead.getClass()});
                LOGGER.log(lr);
            }
        }
        if (Items.currentlyUpdatingByXml() && FIRE_SCM_SOURCE_BUILDS_AFTER_SAVE) {
            this.fireSCMSourceAfterSave(this.getSCMSources());
            if (this.isBuildable()) {
                this.scheduleBuild();
            }
        }
    }

    private synchronized void init2() {
        if (this.sources == null) {
            this.sources = new PersistedList((Saveable)this);
        }
        if (this.nullSCMSource == null) {
            this.nullSCMSource = new NullSCMSource();
        }
        this.nullSCMSource.setOwner((SCMSourceOwner)this);
        for (SCMSource source : this.getSCMSources()) {
            source.setOwner((SCMSourceOwner)this);
        }
        BranchProjectFactory<P, R> factory = this.getProjectFactory();
        factory.setOwner(this);
        if (!(this.getFolderViews() instanceof MultiBranchProjectViewHolder)) {
            this.resetFolderViews();
        }
        if (this.getIcon() == null) {
            this.setIcon(this.newDefaultFolderIcon());
        }
    }

    protected AbstractFolderViewHolder newFolderViewHolder() {
        return new MultiBranchProjectViewHolder(this);
    }

    protected FolderIcon newDefaultFolderIcon() {
        return new MetadataActionFolderIcon();
    }

    public String getIconClassName() {
        String result;
        if (this.sources.size() == 1) {
            result = ((BranchSource)((Object)this.sources.get(0))).getSource().getDescriptor().getIconClassName();
        } else {
            result = null;
            for (int i = 0; i < this.sources.size(); ++i) {
                String iconClassName = ((BranchSource)((Object)this.sources.get(i))).getSource().getDescriptor().getIconClassName();
                if (i == 0) {
                    result = iconClassName;
                    continue;
                }
                if (StringUtils.equals((String)result, (String)iconClassName)) continue;
                result = null;
                break;
            }
        }
        return result != null ? result : this.getDescriptor().getIconClassName();
    }

    public String getSourcePronoun() {
        TreeSet<String> result = new TreeSet<String>();
        for (BranchSource source : this.sources) {
            String pronoun = Util.fixEmptyAndTrim((String)source.getSource().getPronoun());
            if (pronoun == null) continue;
            result.add(pronoun);
        }
        return result.isEmpty() ? this.getPronoun() : StringUtils.join(result, (String)" / ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="False positive: synchronization is handled via double-checked locking")
    public BranchProjectFactory<P, R> getProjectFactory() {
        BranchProjectFactory<P, R> value = this.factory;
        if (value == null) {
            MultiBranchProject multiBranchProject = this;
            synchronized (multiBranchProject) {
                value = this.factory;
                if (value == null) {
                    value = this.newProjectFactory();
                    this.setProjectFactory(value);
                }
            }
        }
        return value;
    }

    public final Class<P> getProjectClass() {
        return this.getDescriptor().getProjectClass();
    }

    public synchronized void setProjectFactory(BranchProjectFactory<P, R> projectFactory) {
        ((Object)projectFactory).getClass();
        if (this.factory == projectFactory) {
            return;
        }
        this.factory = projectFactory;
        this.factory.setOwner(this);
    }

    @NonNull
    protected abstract BranchProjectFactory<P, R> newProjectFactory();

    @Exported
    @NonNull
    public List<BranchSource> getSources() {
        if (this.sources != null) {
            return this.sources.toList();
        }
        return Collections.emptyList();
    }

    @NonNull
    public PersistedList<BranchSource> getSourcesList() {
        return this.sources;
    }

    public void setSourcesList(List<BranchSource> sources) throws IOException {
        Set<String> newIds;
        if (this.sources.isEmpty() || sources.isEmpty()) {
            this.sources.replaceBy(sources);
            return;
        }
        Set<String> oldIds = this.sourceIds((List<BranchSource>)this.sources);
        if (oldIds.containsAll(newIds = this.sourceIds(sources)) || newIds.containsAll(oldIds)) {
            this.sources.replaceBy(sources);
            return;
        }
        HashMap<String, String> changedIds = new HashMap<String, String>();
        HashSet<String> additions = new HashSet<String>(newIds);
        additions.removeAll(oldIds);
        HashSet<String> removals = new HashSet<String>(oldIds);
        removals.removeAll(newIds);
        block0: for (BranchSource addition : sources) {
            String additionId = addition.getSource().getId();
            if (!additions.contains(additionId)) continue;
            for (BranchSource removal : this.sources) {
                String removalId = removal.getSource().getId();
                if (!removals.contains(removalId) || !this.equalButForId(removal.getSource(), addition.getSource())) continue;
                changedIds.put(removalId, additionId);
                removals.remove(removalId);
                additions.remove(additionId);
                continue block0;
            }
        }
        this.sources.replaceBy(sources);
        BranchProjectFactory factory = this.getProjectFactory();
        for (Job item : this.getItems(x$0 -> factory.isProject((Item)x$0))) {
            Branch oldBranch = factory.getBranch(item);
            if (!changedIds.containsKey(oldBranch.getSourceId())) continue;
            Branch newBranch = new Branch((String)changedIds.get(oldBranch.getSourceId()), oldBranch.getHead(), oldBranch.getScm(), oldBranch.getProperties());
            newBranch.setActions(oldBranch.getActions());
            factory.setBranch(item, newBranch);
        }
    }

    private Set<String> sourceIds(List<BranchSource> sources) {
        HashSet<String> result = new HashSet<String>();
        for (BranchSource s : sources) {
            result.add(s.getSource().getId());
        }
        return result;
    }

    private boolean equalButForId(SCMSource a, SCMSource b) {
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        return SOURCE_ID_OMITTED_XSTREAM.toXML((Object)a).equals(SOURCE_ID_OMITTED_XSTREAM.toXML((Object)b));
    }

    @NonNull
    public List<SCMSource> getSCMSources() {
        ArrayList<SCMSource> result = new ArrayList<SCMSource>();
        if (this.sources != null) {
            for (BranchSource source : this.sources) {
                result.add(source.getSource());
            }
        }
        return result;
    }

    @CheckForNull
    public SCMSource getSCMSource(@CheckForNull String sourceId) {
        for (SCMSource source : this.getSCMSources()) {
            if (!source.getId().equals(sourceId)) continue;
            return source;
        }
        return this.nullSCMSource;
    }

    @CheckForNull
    public BranchPropertyStrategy getBranchPropertyStrategy(@NonNull SCMSource source) {
        for (BranchSource s : this.getSources()) {
            if (!s.getSource().equals((Object)source)) continue;
            return s.getStrategy();
        }
        return null;
    }

    @NonNull
    private Branch newBranch(@NonNull SCMSource source, @NonNull SCMHead head) {
        source.getClass();
        head.getClass();
        String sourceId = source.getId();
        if (NullSCMSource.ID.equals(sourceId)) {
            return new Branch.Dead(head, Collections.emptyList());
        }
        BranchPropertyStrategy strategy = this.getBranchPropertyStrategy(source);
        return new Branch(sourceId, head, source.build(head), strategy != null ? strategy.getPropertiesFor(head) : Collections.emptyList());
    }

    @CheckForNull
    public SCMSourceCriteria getSCMSourceCriteria(@NonNull SCMSource source) {
        return null;
    }

    public void onSCMSourceUpdated(@NonNull SCMSource source) {
        if (this.isBuildable()) {
            this.scheduleBuild(0, new BranchIndexingCause());
        }
    }

    public boolean isHasEvents() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void computeChildren(ChildObserver<P> observer, TaskListener listener) throws IOException, InterruptedException {
        block22: {
            try {
                this.srcDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.sources));
            }
            catch (XStreamException e) {
                this.srcDigest = null;
            }
            try {
                this.facDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.getProjectFactory()));
            }
            catch (XStreamException e) {
                this.facDigest = null;
            }
            start = System.currentTimeMillis();
            listener.getLogger().format("[%tc] Starting branch indexing...%n", new Object[]{start});
            try {
                _factory = this.getProjectFactory();
                scmSources = this.getSCMSources();
                sourceActions = new LinkedHashMap<String, List>();
                for (SCMSource var9_13 : scmSources) {
                    try {
                        sourceActions.put(var9_13.getId(), var9_13.fetchActions(null, listener));
                    }
                    catch (IOException | InterruptedException | RuntimeException e) {
                        listener.error("[%tc] Could not update folder level actions from source %s", new Object[]{System.currentTimeMillis(), var9_13.getId()});
                        throw e;
                    }
                }
                if (sourceActions.equals(this.state.sourceActions)) ** GOTO lbl58
                saveProject = false;
                var9_14 = sourceActions.values().iterator();
                while (true) {
                    block23: {
                        if (var9_14.hasNext()) {
                            actions = (List)var9_14.next();
                            var11_24 = actions.iterator();
                            break block22;
                        }
                        var9_15 = new BulkChange((Saveable)this.state);
                        try {
                            this.state.sourceActions.keySet().retainAll(sourceActions.keySet());
                            this.state.sourceActions.putAll(sourceActions);
                            try {
                                var9_15.commit();
                            }
                            catch (IOException | RuntimeException e) {
                                listener.error("[%tc] Could not persist folder level actions", new Object[]{System.currentTimeMillis()});
                                throw e;
                            }
                            if (!saveProject) break block23;
                            try {
                                this.save();
                            }
                            catch (IOException | RuntimeException e) {
                                listener.error("[%tc] Could not persist folder level configuration changes", new Object[]{System.currentTimeMillis()});
                                throw e;
                            }
                        }
                        finally {
                            var9_15.abort();
                        }
                    }
                    for (SCMSource var9_18 : scmSources) {
                        try {
                            var9_18.fetch((SCMHeadObserver)new SCMHeadObserverImpl(var9_18, observer, listener, _factory, new IndexingCauseFactory(), null), listener);
                        }
                        catch (IOException | InterruptedException | RuntimeException e) {
                            listener.error("[%tc] Could not fetch branches from source %s", new Object[]{System.currentTimeMillis(), var9_18.getId()});
                            throw e;
                        }
                    }
                    break;
                }
            }
            catch (Throwable var14_27) {
                end = System.currentTimeMillis();
                listener.getLogger().format("[%tc] Finished branch indexing. Indexing took %s%n", new Object[]{end, Util.getTimeSpanString((long)(end - start))});
                throw var14_27;
            }
            {
                end = System.currentTimeMillis();
                listener.getLogger().format("[%tc] Finished branch indexing. Indexing took %s%n", new Object[]{end, Util.getTimeSpanString((long)(end - start))});
                return;
            }
        }
        while (true) {
            if (!var11_24.hasNext()) ** continue;
            a = (Action)var11_24.next();
            saveProject = this.removeActions(a.getClass()) != false || saveProject != false;
        }
    }

    private void scheduleBuild(BranchProjectFactory<P, R> factory, P item, SCMRevision revision, TaskListener listener, String name, Cause[] causes, Action ... actions) {
        Action[] _actions;
        if (!this.isBuildable()) {
            listener.getLogger().printf("Did not schedule build for branch: %s (%s is disabled)%n", name, this.getDisplayName());
            return;
        }
        int causeCount = 0;
        for (Action action : actions) {
            if (!(action instanceof CauseAction)) continue;
            ++causeCount;
        }
        if (causeCount == 0) {
            _actions = new Action[actions.length + 1];
            _actions[0] = new CauseAction(causes);
            System.arraycopy(actions, 0, _actions, 1, actions.length);
        } else {
            _actions = new Action[actions.length + 1 - causeCount];
            int i = 1;
            ArrayList _causes = new ArrayList();
            Collections.addAll(_causes, causes);
            for (Action a : actions) {
                if (a instanceof CauseAction) {
                    _causes.addAll(((CauseAction)a).getCauses());
                    continue;
                }
                _actions[i++] = a;
            }
            _actions[0] = new CauseAction(_causes);
        }
        if (ParameterizedJobMixIn.scheduleBuild2(item, (int)-1, (Action[])_actions) != null) {
            listener.getLogger().println("Scheduled build for branch: " + name);
            try {
                factory.setRevisionHash(item, revision);
            }
            catch (IOException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error("Could not update last revision hash"));
            }
        } else {
            listener.getLogger().println("Did not schedule build for branch: " + name);
        }
    }

    protected Collection<P> orphanedItems(Collection<P> orphaned, TaskListener listener) throws IOException, InterruptedException {
        BranchProjectFactory<Job, R> _factory = this.getProjectFactory();
        for (Job project : orphaned) {
            if (!_factory.isProject((Item)project)) {
                listener.getLogger().println("Detected unsupported subitem " + String.valueOf(project) + ", skipping");
                continue;
            }
            Branch b = _factory.getBranch(project);
            if (b instanceof Branch.Dead) continue;
            _factory.decorate(_factory.setBranch(project, new Branch.Dead(b)));
        }
        return super.orphanedItems(orphaned, listener);
    }

    @CheckForNull
    public P getItem(String name) {
        String decoded;
        if (name == null) {
            return null;
        }
        Job item = (Job)super.getItem(name);
        if (item != null) {
            return (P)item;
        }
        if (name.indexOf(37) != -1 && (item = (Job)super.getItem(decoded = NameEncoder.decode(name))) != null) {
            return (P)item;
        }
        return (P)((Job)super.getItem(NameEncoder.encode(name)));
    }

    @CheckForNull
    public P getItemByBranchName(@NonNull String branchName) {
        return (P)((Job)super.getItem(NameEncoder.encode(branchName)));
    }

    @Deprecated
    @CheckForNull
    public P getBranch(String name) {
        return this.getItem(name);
    }

    @NonNull
    public ACL getACL() {
        final ACL acl = super.getACL();
        if (this.getParent() instanceof ComputedFolder) {
            return new ACL(){

                public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
                    if (ACL.SYSTEM2.equals(a)) {
                        return true;
                    }
                    if (SUPPRESSED_PERMISSIONS.contains(permission)) {
                        return false;
                    }
                    return acl.hasPermission2(a, permission);
                }
            };
        }
        return acl;
    }

    public String getDescription() {
        String description = super.getDescription();
        if (StringUtils.isNotBlank((String)description)) {
            return description;
        }
        ObjectMetadataAction action = (ObjectMetadataAction)this.getAction(ObjectMetadataAction.class);
        if (action != null) {
            return action.getObjectDescription();
        }
        return super.getDescription();
    }

    public String getDisplayName() {
        ObjectMetadataAction action;
        String displayName = this.getDisplayNameOrNull();
        if (displayName == null && (action = (ObjectMetadataAction)this.getAction(ObjectMetadataAction.class)) != null && StringUtils.isNotBlank((String)action.getObjectDisplayName())) {
            return action.getObjectDisplayName();
        }
        return super.getDisplayName();
    }

    @NonNull
    public File getJobsDir() {
        return new File(this.getRootDir(), "branches");
    }

    public File getRootDirFor(P child) {
        return super.getRootDirFor(child);
    }

    @NonNull
    public File getComputationDir() {
        return new File(this.getRootDir(), "indexing");
    }

    @NonNull
    public MultiBranchProjectDescriptor getDescriptor() {
        return (MultiBranchProjectDescriptor)super.getDescriptor();
    }

    public synchronized BranchIndexing<P, R> getIndexing() {
        return (BranchIndexing)this.getComputation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        ArrayList<SCMSource> _sources = new ArrayList<SCMSource>();
        MultiBranchProject multiBranchProject = this;
        synchronized (multiBranchProject) {
            JSONObject json = req.getSubmittedForm();
            this.setSourcesList(req.bindJSONToList(BranchSource.class, json.opt("sources")));
            for (SCMSource scmSource : this.getSCMSources()) {
                scmSource.setOwner((SCMSourceOwner)this);
                _sources.add(scmSource);
            }
            this.setProjectFactory((BranchProjectFactory)((Object)req.bindJSON(BranchProjectFactory.class, json.getJSONObject("projectFactory"))));
        }
        this.fireSCMSourceAfterSave(_sources);
        this.recalculateAfterSubmitted(this.updateDigests());
    }

    protected void fireSCMSourceAfterSave(List<SCMSource> sources) {
        for (SCMSource scmSource : sources) {
            scmSource.afterSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateDigests() {
        String facDigest;
        String srcDigest;
        try {
            srcDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.sources));
        }
        catch (XStreamException e) {
            srcDigest = null;
        }
        try {
            facDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.getProjectFactory()));
        }
        catch (XStreamException e) {
            facDigest = null;
        }
        try {
            boolean bl = !StringUtils.equals((String)srcDigest, (String)this.srcDigest) || !StringUtils.equals((String)facDigest, (String)this.facDigest);
            return bl;
        }
        finally {
            this.srcDigest = srcDigest;
            this.facDigest = facDigest;
        }
    }

    protected View getWelcomeView() {
        return new MultiBranchProjectEmptyView((ViewGroup)this);
    }

    public View getView(String name) {
        if (name.equals("Welcome")) {
            return this.getWelcomeView();
        }
        return super.getView(name);
    }

    public boolean isBuildable() {
        if (this.sources == null) {
            return false;
        }
        return super.isBuildable() && !this.sources.isEmpty();
    }

    @NonNull
    protected FolderComputation<P> createComputation(FolderComputation<P> previous) {
        return new BranchIndexing(this, (BranchIndexing)previous);
    }

    @NonNull
    public static String rawDecode(@NonNull String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 37 && i + 2 < bytes.length) {
                int u = Character.digit((char)bytes[++i], 16);
                int l = Character.digit((char)bytes[++i], 16);
                if (u != -1 && l != -1) {
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                i -= 2;
            }
            buffer.write(b);
        }
        return new String(buffer.toByteArray(), StandardCharsets.UTF_8);
    }

    static {
        SOURCE_ID_OMITTED_XSTREAM.omitField(SCMSource.class, "id");
        SUPPRESSED_PERMISSIONS = Collections.unmodifiableSet(new HashSet<Permission>(Arrays.asList(Item.CONFIGURE, Item.DELETE, View.CONFIGURE, View.CREATE, View.DELETE)));
    }

    private static class BranchSourceList
    extends PersistedList<BranchSource> {
        BranchSourceList(MultiBranchProject<?, ?> owner) {
            super(owner);
        }

        protected void onModified() throws IOException {
            super.onModified();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                BranchSource branchSource = (BranchSource)((Object)iterator.next());
                branchSource.getSource().setOwner((SCMSourceOwner)((MultiBranchProject)this.owner));
            }
        }
    }

    private static class State
    implements Saveable {
        @NonNull
        private final transient MultiBranchProject<?, ?> owner;
        private final Map<String, List<Action>> sourceActions = new HashMap<String, List<Action>>();

        private State(@NonNull MultiBranchProject<?, ?> owner) {
            this.owner = owner;
        }

        public synchronized void reset() {
            this.sourceActions.clear();
        }

        public synchronized void load() throws IOException {
            if (this.getStateFile().exists()) {
                this.getStateFile().unmarshal((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() throws IOException {
            State state = this;
            synchronized (state) {
                if (BulkChange.contains((Saveable)this)) {
                    return;
                }
                this.getStateFile().write((Object)this);
            }
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getStateFile());
        }

        public final XmlFile getStateFile() {
            return new XmlFile(Items.XSTREAM, new File(this.owner.getRootDir(), "state.xml"));
        }
    }

    private class SCMHeadObserverImpl
    extends SCMHeadObserver {
        @NonNull
        private final SCMSource source;
        @NonNull
        private final ChildObserver<P> observer;
        @NonNull
        private final TaskListener listener;
        @NonNull
        private final BranchProjectFactory<P, R> _factory;
        @NonNull
        private final CauseFactory causeFactory;
        @CheckForNull
        private final SCMHeadEvent<?> event;

        public SCMHeadObserverImpl(@NonNull SCMSource source, @NonNull ChildObserver<P> observer, @NonNull TaskListener listener, @NonNull BranchProjectFactory<P, R> _factory, @CheckForNull CauseFactory causeFactory, SCMHeadEvent<?> event) {
            this.source = source;
            this.observer = observer;
            this.listener = listener;
            this._factory = _factory;
            this.causeFactory = causeFactory;
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) throws IOException, InterruptedException {
            Branch branch = MultiBranchProject.this.newBranch(this.source, head);
            String rawName = branch.getName();
            String encodedName = branch.getEncodedName();
            Job project = (Job)this.observer.shouldUpdate(encodedName);
            try {
                Branch origBranch = this.getOrigBranch(project);
                this.setBranchActions(head, branch, origBranch);
                Action[] revisionActions = this.getRevisionActions(revision, rawName);
                if (project != null) {
                    if (origBranch == null) {
                        return;
                    }
                    this.observeExisting(head, revision, branch, rawName, project, origBranch, revisionActions);
                } else {
                    this.observeNew(head, revision, branch, rawName, encodedName, revisionActions);
                }
            }
            finally {
                this.observer.completed(encodedName);
            }
        }

        private void observeExisting(@NonNull SCMHead head, @NonNull SCMRevision revision, @NonNull Branch branch, String rawName, P project, Branch origBranch, Action[] revisionActions) {
            boolean rebuild = origBranch instanceof Branch.Dead && !(branch instanceof Branch.Dead) || !this.source.getId().equals(origBranch.getSourceId());
            boolean needSave = !branch.equals(origBranch) || !branch.getActions().equals(origBranch.getActions()) || !Util.getDigestOf((String)Items.XSTREAM2.toXML((Object)branch.getScm())).equals(Util.getDigestOf((String)Items.XSTREAM2.toXML((Object)origBranch.getScm())));
            this._factory.decorate(this._factory.setBranch(project, branch));
            String displayName = this.getProjectDisplayName(project, rawName);
            try {
                needSave = needSave || !Objects.equals(displayName, project.getDisplayNameOrNull());
                project.setDisplayName(displayName);
            }
            catch (IOException e) {
                this.listener.getLogger().format("DisplayName update failed for (%s) to '%s': %s", rawName, displayName, e.getMessage());
            }
            if (rebuild) {
                needSave = true;
                this.listener.getLogger().format("%s reopened: %s (%s)%n", StringUtils.defaultIfEmpty((String)head.getPronoun(), (String)"Branch"), rawName, revision);
                this.doAutomaticBuilds(head, revision, rawName, project, revisionActions, null, null);
            } else {
                SCMRevision scmLastBuiltRevision = this._factory.getRevision(project);
                if (this.changesDetected(revision, project, scmLastBuiltRevision)) {
                    this.listener.getLogger().format("Changes detected: %s (%s \u2192 %s)%n", rawName, scmLastBuiltRevision, revision);
                    needSave = true;
                    SCMRevision scmLastSeenRevision = this.lastSeenRevisionOrDefault(project, scmLastBuiltRevision);
                    this.doAutomaticBuilds(head, revision, rawName, project, revisionActions, scmLastBuiltRevision, scmLastSeenRevision);
                } else {
                    this.listener.getLogger().format("No changes detected: %s (still at %s)%n", rawName, revision);
                }
            }
            try {
                if (needSave) {
                    project.save();
                }
            }
            catch (IOException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)this.listener.error("Could not save changes to " + rawName));
            }
        }

        private void observeNew(@NonNull SCMHead head, @NonNull SCMRevision revision, @NonNull Branch branch, String rawName, String encodedName, Action[] revisionActions) {
            Object project;
            if (!this.observer.mayCreate(encodedName)) {
                this.listener.getLogger().println("Ignoring duplicate branch project " + rawName);
                return;
            }
            try (ChildNameGenerator.Trace trace = ChildNameGenerator.beforeCreateItem((AbstractFolder)MultiBranchProject.this, (String)encodedName, (String)branch.getName());){
                if (MultiBranchProject.this.getItem(encodedName) != null) {
                    throw new IllegalStateException("JENKINS-42511: attempted to redundantly create " + encodedName + " in " + String.valueOf((Object)MultiBranchProject.this));
                }
                project = this._factory.newInstance(branch);
            }
            if (!project.getName().equals(encodedName)) {
                throw new IllegalStateException("Name of created project " + String.valueOf(project) + " did not match expected " + encodedName);
            }
            this._factory.decorate(project);
            try (BulkChange bc = new BulkChange(project);){
                this.observer.created(project);
                project.setDisplayName(this.getProjectDisplayName(project, rawName));
                bc.commit();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.doAutomaticBuilds(head, revision, rawName, project, revisionActions, null, null);
        }

        private String getProjectDisplayName(@NonNull P project, @NonNull String rawName) {
            MultiBranchProjectDisplayNamingStrategy naming = null;
            List traits = this.source.getTraits();
            if (null != traits) {
                Optional<SCMSourceTrait> trait = traits.stream().filter(t -> t instanceof MultiBranchProjectDisplayNamingTrait).findFirst();
                naming = trait.map(scmSourceTrait -> (MultiBranchProjectDisplayNamingTrait)((Object)scmSourceTrait)).map(MultiBranchProjectDisplayNamingTrait::getDisplayNamingStrategy).orElse(null);
            }
            if (naming == null) {
                naming = MultiBranchProjectDisplayNamingStrategy.RAW_AND_OBJECT_DISPLAY_NAME;
            }
            ObjectMetadataAction action = naming.needsObjectDisplayName() ? (ObjectMetadataAction)project.getAction(ObjectMetadataAction.class) : null;
            String objectDisplayName = Optional.ofNullable(action).map(ObjectMetadataAction::getObjectDisplayName).orElse("");
            String generatedName = naming.generateName(rawName, objectDisplayName);
            return StringUtils.isBlank((String)generatedName) || generatedName.equals(project.getName()) ? null : generatedName;
        }

        private boolean changesDetected(@NonNull SCMRevision revision, @NonNull P project, SCMRevision scmLastBuiltRevision) {
            boolean changesDetected = false;
            if (revision.isDeterministic()) {
                if (!revision.equals((Object)scmLastBuiltRevision)) {
                    changesDetected = true;
                }
            } else {
                PollingResult pollingResult;
                SCMTriggerItem scmProject = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(project);
                if (scmProject != null && (pollingResult = scmProject.poll(this.listener)).hasChanges()) {
                    changesDetected = true;
                }
            }
            return changesDetected;
        }

        private Action[] getRevisionActions(@NonNull SCMRevision revision, String rawName) {
            Action[] revisionActions = new Action[]{};
            try {
                List actions = this.source.fetchActions(revision, this.event, this.listener);
                revisionActions = actions.toArray(new Action[actions.size()]);
            }
            catch (IOException | InterruptedException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)this.listener.error("Could not fetch metadata for revision %s of branch %s", new Object[]{revision, rawName}));
            }
            return revisionActions;
        }

        private void setBranchActions(@NonNull SCMHead head, @NonNull Branch branch, @CheckForNull Branch origBranch) {
            block2: {
                try {
                    branch.setActions(this.source.fetchActions(head, this.event, this.listener));
                }
                catch (IOException | InterruptedException e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)this.listener.error("Could not fetch metadata of branch %s", new Object[]{branch.getName()}));
                    if (origBranch == null) break block2;
                    branch.setActions(origBranch.getActions());
                }
            }
        }

        private Branch getOrigBranch(P project) {
            Branch origBranch = null;
            if (project != null) {
                if (!this._factory.isProject((Item)project)) {
                    this.listener.getLogger().println("Detected unsupported subitem " + ModelHyperlinkNote.encodeTo(project) + ", skipping");
                } else {
                    origBranch = this._factory.getBranch(project);
                    if (!(origBranch instanceof Branch.Dead) && !this.source.getId().equals(origBranch.getSourceId())) {
                        int ourPriority = Integer.MAX_VALUE;
                        int oldPriority = Integer.MAX_VALUE;
                        int p = 1;
                        for (BranchSource s : MultiBranchProject.this.sources) {
                            String sId = s.getSource().getId();
                            if (sId.equals(this.source.getId())) {
                                ourPriority = p;
                            }
                            if (sId.equals(origBranch.getSourceId())) {
                                oldPriority = p;
                            }
                            ++p;
                        }
                        if (oldPriority < ourPriority) {
                            this.listener.getLogger().println("Ignoring " + ModelHyperlinkNote.encodeTo(project) + " from source #" + ourPriority + " as source #" + oldPriority + " owns the branch name");
                            origBranch = null;
                        } else if (oldPriority == Integer.MAX_VALUE) {
                            this.listener.getLogger().println("Takeover for " + ModelHyperlinkNote.encodeTo(project) + " by source #" + ourPriority + " from source that no longer exists");
                        } else {
                            this.listener.getLogger().println("Takeover for " + ModelHyperlinkNote.encodeTo(project) + " by source #" + ourPriority + " from source #" + oldPriority);
                        }
                    }
                }
            }
            return origBranch;
        }

        private SCMRevision lastSeenRevisionOrDefault(@NonNull P project, SCMRevision scmLastBuiltRevision) {
            SCMRevision scmLastSeenRevision = this._factory.getLastSeenRevision(project);
            if (scmLastSeenRevision == null && scmLastBuiltRevision != null) {
                scmLastSeenRevision = scmLastBuiltRevision;
                try {
                    this._factory.setLastSeenRevisionHash(project, scmLastBuiltRevision);
                }
                catch (IOException e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)this.listener.error("Could not update last seen revision hash"));
                }
            }
            return scmLastSeenRevision;
        }

        private void doAutomaticBuilds(@NonNull SCMHead head, @NonNull SCMRevision revision, @NonNull String rawName, @NonNull P project, Action[] revisionActions, SCMRevision scmLastBuiltRevision, SCMRevision scmLastSeenRevision) {
            if (this.isAutomaticBuild(head, revision, scmLastBuiltRevision, scmLastSeenRevision)) {
                MultiBranchProject.this.scheduleBuild(this._factory, project, revision, this.listener, rawName, this.causeFactory.create(this.source), revisionActions);
            } else {
                this.listener.getLogger().format("No automatic build triggered for %s%n", rawName);
            }
            try {
                this._factory.setLastSeenRevisionHash(project, revision);
            }
            catch (IOException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)this.listener.error("Could not update last seen revision hash"));
            }
        }

        private boolean isAutomaticBuild(@NonNull SCMHead head, @NonNull SCMRevision currRevision, @CheckForNull SCMRevision lastBuiltRevision, @CheckForNull SCMRevision lastSeenRevision) {
            BranchSource branchSource = null;
            for (BranchSource s : MultiBranchProject.this.sources) {
                if (!s.getSource().getId().equals(this.source.getId())) continue;
                branchSource = s;
                break;
            }
            if (branchSource == null) {
                return false;
            }
            List<BranchBuildStrategy> buildStrategies = branchSource.getBuildStrategies();
            if (buildStrategies.isEmpty()) {
                return !(head instanceof TagSCMHead);
            }
            for (BranchBuildStrategy s : buildStrategies) {
                if (!s.automaticBuild(this.source, head, currRevision, lastBuiltRevision, lastSeenRevision, this.listener)) continue;
                return true;
            }
            return false;
        }
    }

    private static class IndexingCauseFactory
    extends CauseFactory {
        private IndexingCauseFactory() {
        }

        @Override
        @NonNull
        Cause[] create(SCMSource source) {
            return new Cause[]{new BranchIndexingCause()};
        }
    }

    private static abstract class CauseFactory {
        private CauseFactory() {
        }

        @NonNull
        abstract Cause[] create(SCMSource var1);
    }

    public static class BranchIndexing<P extends Job<P, R>, R extends Run<P, R>>
    extends FolderComputation<P> {
        public BranchIndexing(@NonNull MultiBranchProject<P, R> project, @CheckForNull BranchIndexing<P, R> previousIndexing) {
            super(project, previousIndexing);
        }

        @NonNull
        public MultiBranchProject<P, R> getParent() {
            return (MultiBranchProject)super.getParent();
        }

        @NonNull
        protected XmlFile getDataFile() {
            return new XmlFile(Items.XSTREAM, new File(this.getParent().getComputationDir(), "indexing.xml"));
        }

        @NonNull
        public File getLogFile() {
            return new File(this.getParent().getComputationDir(), "indexing.log");
        }

        public String getDisplayName() {
            return Messages.MultiBranchProject_BranchIndexing_displayName(this.getParent().getSourcePronoun());
        }

        @NonNull
        public String getUrl() {
            return this.getParent().getUrl() + "indexing/";
        }

        public String getSearchUrl() {
            return "indexing/";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long start = System.currentTimeMillis();
            try {
                super.run();
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                LOGGER.log(Level.FINE, "{0} #{1,time,yyyyMMdd.HHmmss} branch indexing action completed: {2} in {3}", new Object[]{this.getParent().getFullName(), start, this.getResult(), Util.getTimeSpanString((long)(end - start))});
                throw throwable;
            }
            long end = System.currentTimeMillis();
            LOGGER.log(Level.FINE, "{0} #{1,time,yyyyMMdd.HHmmss} branch indexing action completed: {2} in {3}", new Object[]{this.getParent().getFullName(), start, this.getResult(), Util.getTimeSpanString((long)(end - start))});
        }
    }

    @Extension
    public static class CopyItemVeto
    extends ItemListener {
        public void onCheckCopy(Item item, ItemGroup parent) throws Failure {
            if (item.getParent() instanceof MultiBranchProject) {
                throw new Failure(Messages.MultiBranchProject_CopyItemVeto_reason());
            }
        }
    }

    @Extension
    public static class StateActionFactory
    extends TransientActionFactory<MultiBranchProject> {
        public Class<MultiBranchProject> type() {
            return MultiBranchProject.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull MultiBranchProject target) {
            ArrayList<Action> result = new ArrayList<Action>();
            MultiBranchProject project = target;
            for (BranchSource b : project.getSources()) {
                List<Action> actions = project.state.sourceActions.get(b.getSource().getId());
                if (actions == null || actions.isEmpty()) continue;
                result.addAll(actions);
            }
            return result;
        }
    }

    private static class EventCauseFactory
    extends CauseFactory {
        @NonNull
        private final SCMHeadEvent<?> event;

        EventCauseFactory(SCMHeadEvent<?> event) {
            this.event = event;
        }

        @Override
        @NonNull
        Cause[] create(SCMSource source) {
            Cause[] eventCauses = this.event.asCauses();
            Cause[] result = new Cause[eventCauses.length + 1];
            result[0] = new BranchEventCause((SCMEvent<?>)this.event, this.event.descriptionFor(source));
            if (eventCauses.length > 0) {
                System.arraycopy(eventCauses, 0, result, 1, eventCauses.length);
            }
            return result;
        }
    }

    @Extension
    public static class SCMEventListenerImpl
    extends SCMEventListener {
        private final EventOutputStreams globalEvents = this.createGlobalEvents();

        private EventOutputStreams createGlobalEvents() {
            File oldFile;
            File eventsFile;
            File logsDir = new File(Jenkins.get().getRootDir(), "logs");
            if (!logsDir.isDirectory() && !logsDir.mkdirs()) {
                LOGGER.log(Level.WARNING, "Could not create logs directory: {0}", logsDir);
            }
            if (!(eventsFile = new File(logsDir, MultiBranchProject.class.getName() + ".log")).isFile() && (oldFile = new File(logsDir.getParent(), eventsFile.getName())).isFile() && !oldFile.renameTo(eventsFile)) {
                FileUtils.deleteQuietly((File)oldFile);
            }
            return new EventOutputStreams(new EventOutputStreams.OutputFile(){

                @NonNull
                public File get() {
                    return eventsFile;
                }
            }, 250L, TimeUnit.MILLISECONDS, 1024, true, 0x100000L, 5);
        }

        @Restricted(value={NoExternalUse.class})
        public StreamTaskListener globalEventsListener() {
            return new StreamBuildListener(this.globalEvents.get(), StandardCharsets.UTF_8);
        }

        public void onSCMHeadEvent(SCMHeadEvent<?> event) {
            try (StreamTaskListener global = this.globalEventsListener();){
                String eventDescription = StringUtils.defaultIfBlank((String)event.description(), (String)event.getClass().getName());
                String eventType = event.getType().name();
                String eventOrigin = event.getOrigin();
                long eventTimestamp = event.getTimestamp();
                long started = System.currentTimeMillis();
                global.getLogger().format("[%tc] Received %s %s event from %s with timestamp %tc%n", started, eventDescription, eventType, eventOrigin, eventTimestamp);
                LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: onSCMHeadEvent", new Object[]{eventDescription, eventType, eventTimestamp});
                int matchCount = 0;
                try {
                    if (SCMEvent.Type.CREATED == event.getType()) {
                        matchCount = this.processHeadCreate(event, (TaskListener)global, eventDescription, eventType, eventOrigin, eventTimestamp, matchCount);
                    } else if (SCMEvent.Type.UPDATED == event.getType() || SCMEvent.Type.REMOVED == event.getType()) {
                        matchCount = this.processHeadUpdate(event, (TaskListener)global, eventDescription, eventType, eventOrigin, eventTimestamp, matchCount);
                    }
                }
                catch (InterruptedException e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)global.error("[%tc] Interrupted while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), eventDescription, eventType, eventOrigin, eventTimestamp}));
                }
                long ended = System.currentTimeMillis();
                global.getLogger().format("[%tc] Finished processing %s %s event from %s with timestamp %tc, processed in %dms. Matched %d.%n", ended, eventDescription, eventType, eventOrigin, eventTimestamp, ended - started, matchCount);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not close global event log file", e);
            }
        }

        /*
         * Loose catch block
         */
        private int processHeadCreate(SCMHeadEvent<?> event, TaskListener global, String eventDescription, String eventType, String eventOrigin, long eventTimestamp, int matchCount) throws IOException, InterruptedException {
            HashSet<String> sourceIds = new HashSet<String>();
            for (MultiBranchProject p : Jenkins.get().getAllItems(MultiBranchProject.class)) {
                String pFullName = p.getFullName();
                if (!p.isBuildable()) {
                    LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Ignoring {3} because it is disabled", new Object[]{eventDescription, eventType, eventTimestamp, pFullName});
                    continue;
                }
                sourceIds.clear();
                LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Checking {3} for a match", new Object[]{eventDescription, eventType, eventTimestamp, pFullName});
                boolean haveMatch = false;
                BranchProjectFactory _factory = p.getProjectFactory();
                block20: for (SCMSource source : p.getSCMSources()) {
                    if (event.isMatch(source)) {
                        LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Project {3}: Matches source {4}", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, source.getId()});
                        for (SCMHead h : event.heads(source).keySet()) {
                            String name = h.getName();
                            Object job = p.getItemByBranchName(name);
                            if (job == null) {
                                LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Project {3}: Source {4}: Match: {5}", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, source.getId(), name});
                                haveMatch = true;
                                ++matchCount;
                                global.getLogger().format("Found match against %s (new branch %s)%n", pFullName, name);
                                break block20;
                            }
                            Branch branch = _factory.getBranch(job);
                            if (branch instanceof Branch.Dead) {
                                LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Project {3}: Source {4}: Match: {5}", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, source.getId(), name});
                                haveMatch = true;
                                ++matchCount;
                                global.getLogger().format("Found match against %s (resurrect branch %s)%n", pFullName, name);
                                break block20;
                            }
                            String sourceId = branch.getSourceId();
                            if (StringUtils.equals((String)sourceId, (String)source.getId())) {
                                LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Project {3}: Source {4}: Already have: {5}", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, source.getId(), name});
                                continue;
                            }
                            if (sourceIds.contains(sourceId)) {
                                LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Project {3}: Source {4}: Ignored as already have {5} from higher priority source {6}", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, source.getId(), name, sourceId});
                                continue;
                            }
                            LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Project {3}: Source {4}: Match: {5} overriding lower priority source {6}", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, source.getId(), name, sourceId});
                            haveMatch = true;
                            ++matchCount;
                            global.getLogger().format("Found match against %s (takeover branch %s)%n", pFullName, name);
                            break block20;
                        }
                        LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Project {3}: No new projects for {4}", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, source.getId()});
                    } else {
                        LOGGER.log(Level.FINEST, "{0} {1} {2,date} {2,time}: Project {3}: Does not matches source {4}", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, source.getId()});
                    }
                    sourceIds.add(source.getId());
                }
                if (!haveMatch) continue;
                long start = System.currentTimeMillis();
                try {
                    StreamTaskListener listener = p.getComputation().createEventsListener();
                    try {
                        ChildObserver childObserver = p.openEventsChildObserver();
                        try {
                            long end;
                            try {
                                listener.getLogger().format("[%tc] Received %s %s event from %s with timestamp %tc%n", start, eventDescription, eventType, eventOrigin, eventTimestamp);
                                for (SCMSource source : p.getSCMSources()) {
                                    if (!event.isMatch(source)) continue;
                                    SCMSourceCriteria sCMSourceCriteria = p.getSCMSourceCriteria(source);
                                    MultiBranchProject multiBranchProject = p;
                                    Objects.requireNonNull(multiBranchProject);
                                    source.fetch(sCMSourceCriteria, (SCMHeadObserver)multiBranchProject.new SCMHeadObserverImpl(source, childObserver, (TaskListener)listener, _factory, new EventCauseFactory(event), event), event, (TaskListener)listener);
                                }
                            }
                            catch (IOException e) {
                                Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error(e.getMessage()));
                                end = System.currentTimeMillis();
                                listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventDescription, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                                continue;
                            }
                            catch (InterruptedException e2) {
                                listener.error(e2.getMessage());
                                throw e2;
                                {
                                    catch (Throwable throwable) {
                                        long end2 = System.currentTimeMillis();
                                        listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end2, eventDescription, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end2 - start)));
                                        throw throwable;
                                    }
                                }
                            }
                            end = System.currentTimeMillis();
                            listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventDescription, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                        }
                        finally {
                            if (childObserver == null) continue;
                            childObserver.close();
                        }
                    }
                    finally {
                        if (listener == null) continue;
                        listener.close();
                    }
                }
                catch (IOException e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)global.error("[%tc] %s encountered an error while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventDescription, eventType, eventOrigin, eventTimestamp}));
                }
                catch (InterruptedException e) {
                    global.error("[%tc] %s was interrupted while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventDescription, eventType, eventOrigin, eventTimestamp});
                    throw e;
                }
            }
            return matchCount;
        }

        /*
         * Could not resolve type clashes
         * Loose catch block
         */
        private int processHeadUpdate(SCMHeadEvent<?> event, TaskListener global, String eventDescription, String eventType, String eventOrigin, long eventTimestamp, int matchCount) throws InterruptedException {
            IdentityHashMap<SCMSource, SCMHead> matches = new IdentityHashMap<SCMSource, SCMHead>();
            HashSet<String> candidateNames = new HashSet<String>();
            IdentityHashMap<SCMSource, Map> revisionMaps = new IdentityHashMap<SCMSource, Map>();
            HashSet<Object> jobs = new HashSet<Object>();
            for (MultiBranchProject p : Jenkins.get().getAllItems(MultiBranchProject.class)) {
                Object i22;
                String pFullName = p.getFullName();
                if (!p.isBuildable()) {
                    LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Ignoring {3} because it is disabled", new Object[]{eventDescription, eventType, eventTimestamp, pFullName});
                    continue;
                }
                LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Checking {3} for a match", new Object[]{eventDescription, eventType, eventTimestamp, pFullName});
                BranchProjectFactory _factory = p.getProjectFactory();
                matches.clear();
                candidateNames.clear();
                revisionMaps.clear();
                for (SCMSource source : p.getSCMSources()) {
                    Map eventHeads;
                    if (!event.isMatch(source) || (eventHeads = event.heads(source)).isEmpty()) continue;
                    revisionMaps.put(source, eventHeads);
                    for (SCMHead h : eventHeads.keySet()) {
                        candidateNames.add(h.getName());
                    }
                }
                jobs.clear();
                block41: for (Object i22 : p.getItems(i -> _factory.isProject((Item)i) && candidateNames.contains(_factory.getBranch(i).getName()))) {
                    SCMRevision lastBuild;
                    SCMRevision revision;
                    Branch branch = _factory.getBranch(i22);
                    if (branch instanceof Branch.Dead) {
                        LOGGER.log(Level.FINEST, "{0} {1} {2,date} {2,time}: Checking {3} -> Resurrect dead branch {4} (job {5})?", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, branch.getName(), i22.getName()});
                        for (SCMSource src : p.getSCMSources()) {
                            Map revisionMap = (Map)revisionMaps.get(src);
                            if (revisionMap == null) continue;
                            SCMHead head = branch.getHead();
                            for (SCMHead h : revisionMap.keySet()) {
                                if (!h.getName().equals(head.getName())) continue;
                                matches.put(src, head);
                                jobs.add(i22);
                                continue block41;
                            }
                        }
                        continue;
                    }
                    LOGGER.log(Level.FINEST, "{0} {1} {2,date} {2,time}: Checking {3} -> Matches existing branch {4} (job {5})?", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, branch.getName(), i22.getName()});
                    SCMSource src = p.getSCMSource(branch.getSourceId());
                    if (src == null) continue;
                    Object revisionMap = (Map)revisionMaps.get(src);
                    if (revisionMap == null) {
                        LOGGER.log(Level.FINEST, "{0} {1} {2,date} {2,time}: Checking {3} -> Event does not match current source of {4} (job {5}), checking for take-over", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, branch.getName(), i22.getName()});
                        int ourPriority = Integer.MAX_VALUE;
                        int oldPriority = Integer.MAX_VALUE;
                        SCMSource ourSource = null;
                        int priority = 1;
                        for (SCMSource s : p.getSCMSources()) {
                            String sId = s.getId();
                            Map rMap = (Map)revisionMaps.get(s);
                            if (ourPriority > priority && oldPriority > priority && rMap != null) {
                                for (SCMHead h : rMap.keySet()) {
                                    if (!branch.getName().equals(h.getName())) continue;
                                    ourPriority = priority;
                                    ourSource = s;
                                    break;
                                }
                            }
                            if (sId.equals(src.getId())) {
                                oldPriority = priority;
                            }
                            ++priority;
                        }
                        if (oldPriority < ourPriority) {
                            LOGGER.log(Level.FINEST, "{0} {1} {2,date} {2,time}: Checking {3} -> Ignoring event for {4} (job {5}) from source #{6} as source #{7} owns the branch name", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, branch.getName(), i22.getName(), ourPriority, oldPriority});
                            continue;
                        }
                        LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Checking {3} -> Takeover event for {4} (job {5}) by source #{5} from source #{6}", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, branch.getName(), i22.getName(), ourPriority, oldPriority});
                        assert (ourSource != null);
                        src = ourSource;
                        revisionMap = (Map)revisionMaps.get(ourSource);
                        assert (revisionMap != null);
                    }
                    SCMHead head = branch.getHead();
                    boolean match = false;
                    for (SCMHead h : revisionMap.keySet()) {
                        if (!h.getName().equals(head.getName())) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                    LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Checking {3} -> Event matches source of {4} (job {5})", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, branch.getName(), i22.getName()});
                    if (SCMEvent.Type.UPDATED == event.getType() && (revision = (SCMRevision)revisionMap.get(head)) != null && revision.isDeterministic() && revision.equals((Object)(lastBuild = _factory.getRevision(i22)))) {
                        LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Checking {3} -> Ignoring event as revision {4} is same as last build of {5} (job {6})", new Object[]{eventDescription, eventType, eventTimestamp, pFullName, revision, branch.getName(), i22.getName()});
                        continue;
                    }
                    matches.put(src, head);
                    jobs.add(i22);
                }
                if (!matches.isEmpty()) {
                    ++matchCount;
                    global.getLogger().format("Found match against %s%n", pFullName);
                    long start = System.currentTimeMillis();
                    try {
                        StreamTaskListener listener = p.getComputation().createEventsListener();
                        try {
                            ChildObserver childObserver = p.openEventsChildObserver();
                            try {
                                long end;
                                try {
                                    listener.getLogger().format("[%tc] Received %s %s event from %s with timestamp %tc%n", start, eventDescription, eventType, eventOrigin, eventTimestamp);
                                    for (Map.Entry m : matches.entrySet()) {
                                        SCMSource sCMSource = (SCMSource)m.getKey();
                                        SCMSourceCriteria sCMSourceCriteria = p.getSCMSourceCriteria((SCMSource)m.getKey());
                                        MultiBranchProject multiBranchProject = p;
                                        Objects.requireNonNull(multiBranchProject);
                                        sCMSource.fetch(sCMSourceCriteria, (SCMHeadObserver)multiBranchProject.new SCMHeadObserverImpl((SCMSource)m.getKey(), childObserver, (TaskListener)listener, _factory, new EventCauseFactory(event), event), event, (TaskListener)listener);
                                    }
                                    Set names = childObserver.observed();
                                    for (Job j : jobs) {
                                        if (names.contains(j.getName())) continue;
                                        Branch branch = _factory.getBranch(j);
                                        String sourceId = branch.getSourceId();
                                        boolean foundSource = false;
                                        for (SCMSource s : matches.keySet()) {
                                            if (!sourceId.equals(s.getId())) continue;
                                            foundSource = true;
                                        }
                                        if (!foundSource) continue;
                                        _factory.decorate(_factory.setBranch(j, new Branch.Dead(branch)));
                                        j.save();
                                    }
                                }
                                catch (IOException e) {
                                    Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error(e.getMessage()));
                                    end = System.currentTimeMillis();
                                    listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventDescription, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    listener.error(e.getMessage());
                                    throw e;
                                    {
                                        catch (Throwable throwable) {
                                            long end2 = System.currentTimeMillis();
                                            listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end2, eventDescription, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end2 - start)));
                                            throw throwable;
                                        }
                                    }
                                }
                                end = System.currentTimeMillis();
                                listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventDescription, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                                continue;
                            }
                            finally {
                                if (childObserver == null) continue;
                                childObserver.close();
                                continue;
                            }
                        }
                        finally {
                            if (listener == null) continue;
                            listener.close();
                            continue;
                        }
                    }
                    catch (IOException e) {
                        Functions.printStackTrace((Throwable)e, (PrintWriter)global.error("[%tc] %s encountered an error while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventDescription, eventType, eventOrigin, eventTimestamp}));
                        continue;
                    }
                    catch (InterruptedException e) {
                        global.error("[%tc] %s was interrupted while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventDescription, eventType, eventOrigin, eventTimestamp});
                        throw e;
                    }
                }
                boolean haveMatch = false;
                i22 = p.getSCMSources().iterator();
                while (i22.hasNext()) {
                    SCMSource source = (SCMSource)i22.next();
                    if (!event.isMatch(source)) continue;
                    for (SCMHead h : event.heads(source).keySet()) {
                        if (p.getItemByBranchName(h.getName()) != null) continue;
                        haveMatch = true;
                        break;
                    }
                    if (!haveMatch) break;
                    ++matchCount;
                    global.getLogger().format("Found match against %s%n", pFullName);
                    break;
                }
                if (!haveMatch) continue;
                long start = System.currentTimeMillis();
                try {
                    StreamTaskListener listener = p.getComputation().createEventsListener();
                    try {
                        ChildObserver childObserver = p.openEventsChildObserver();
                        try {
                            long end;
                            listener.getLogger().format("[%tc] Received %s %s event from %s with timestamp %tc%n", start, eventDescription, eventType, eventOrigin, eventTimestamp);
                            try {
                                for (SCMSource source : p.getSCMSources()) {
                                    if (!event.isMatch(source)) continue;
                                    SCMSourceCriteria sCMSourceCriteria = p.getSCMSourceCriteria(source);
                                    MultiBranchProject multiBranchProject = p;
                                    Objects.requireNonNull(multiBranchProject);
                                    source.fetch(sCMSourceCriteria, (SCMHeadObserver)multiBranchProject.new SCMHeadObserverImpl(source, childObserver, (TaskListener)listener, _factory, new EventCauseFactory(event), event), event, (TaskListener)listener);
                                }
                            }
                            catch (IOException e) {
                                Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error(e.getMessage()));
                                end = System.currentTimeMillis();
                                listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventDescription, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                                continue;
                            }
                            catch (InterruptedException e) {
                                listener.error(e.getMessage());
                                throw e;
                                {
                                    catch (Throwable throwable) {
                                        long end3 = System.currentTimeMillis();
                                        listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end3, eventDescription, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end3 - start)));
                                        throw throwable;
                                    }
                                }
                            }
                            end = System.currentTimeMillis();
                            listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventDescription, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                        }
                        finally {
                            if (childObserver == null) continue;
                            childObserver.close();
                        }
                    }
                    finally {
                        if (listener == null) continue;
                        listener.close();
                    }
                }
                catch (IOException e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)global.error("[%tc] %s encountered an error while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventDescription, eventType, eventOrigin, eventTimestamp}));
                }
                catch (InterruptedException e) {
                    global.error("[%tc] %s was interrupted while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventDescription, eventType, eventOrigin, eventTimestamp});
                    throw e;
                }
            }
            return matchCount;
        }

        /*
         * Exception decompiling
         */
        public void onSCMSourceEvent(SCMSourceEvent<?> event) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

