/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderDescriptor;
import com.cloudbees.hudson.plugins.folder.ChildNameGenerator;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchProjectFactoryDescriptor;
import jenkins.branch.BranchSource;
import jenkins.branch.MetadataActionFolderIcon;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.NameEncoder;
import jenkins.branch.NameMangler;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceDescriptor;
import org.jvnet.tiger_types.Types;

public abstract class MultiBranchProjectDescriptor
extends AbstractFolderDescriptor {
    @NonNull
    private final Class<? extends Job> projectClass;

    protected MultiBranchProjectDescriptor(Class<? extends MultiBranchProject<?, ?>> clazz, Class<? extends Job> projectClass) {
        super(clazz);
        this.projectClass = projectClass;
    }

    protected MultiBranchProjectDescriptor(Class<? extends MultiBranchProject<?, ?>> clazz) {
        super(clazz);
        this.projectClass = MultiBranchProjectDescriptor.inferProjectClass(clazz);
    }

    protected MultiBranchProjectDescriptor() {
        this.projectClass = MultiBranchProjectDescriptor.inferProjectClass(this.clazz);
    }

    private static Class<? extends Job> inferProjectClass(Class<? extends MultiBranchProject> clazz) {
        Type bt = Types.getBaseClass(clazz, MultiBranchProject.class);
        if (bt instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)bt;
            Class p = Types.erasure((Type)pt.getActualTypeArguments()[0]);
            if (!Job.class.isAssignableFrom(p)) {
                throw new AssertionError((Object)("Cannot infer job type produced by " + String.valueOf(clazz) + " perhaps use the explicit constructor"));
            }
            return p;
        }
        throw new AssertionError((Object)("Cannot infer job type produced by " + String.valueOf(clazz) + " perhaps use the explicit constructor"));
    }

    @NonNull
    public Class<? extends Job> getProjectClass() {
        return this.projectClass;
    }

    @NonNull
    public Class<? extends MultiBranchProject> getClazz() {
        return this.clazz.asSubclass(MultiBranchProject.class);
    }

    @NonNull
    public List<SCMSourceDescriptor> getSCMSourceDescriptors(boolean onlyUserInstantiable) {
        return SCMSourceDescriptor.forOwner(this.getClazz(), (boolean)onlyUserInstantiable);
    }

    @NonNull
    public List<BranchProjectFactoryDescriptor> getProjectFactoryDescriptors() {
        ArrayList<BranchProjectFactoryDescriptor> result = new ArrayList<BranchProjectFactoryDescriptor>();
        for (BranchProjectFactoryDescriptor descriptor : ExtensionList.lookup(BranchProjectFactoryDescriptor.class)) {
            if (!descriptor.isApplicable(this.getClazz()) || !descriptor.getProjectClass().isAssignableFrom(this.getProjectClass())) continue;
            result.add(descriptor);
        }
        return result;
    }

    @NonNull
    public Descriptor<BranchSource> getBranchSourceDescriptor() {
        return Jenkins.get().getDescriptorOrDie(BranchSource.class);
    }

    public List<FolderIconDescriptor> getIconDescriptors() {
        return Collections.singletonList((FolderIconDescriptor)Jenkins.get().getDescriptorByType(MetadataActionFolderIcon.DescriptorImpl.class));
    }

    public boolean isIconConfigurable() {
        return true;
    }

    @NonNull
    public <I extends TopLevelItem> ChildNameGenerator<AbstractFolder<I>, I> childNameGenerator() {
        return ChildNameGeneratorImpl.INSTANCE;
    }

    public static class ChildNameGeneratorImpl<P extends Job<P, R>, R extends Run<P, R>>
    extends ChildNameGenerator<MultiBranchProject<P, R>, P> {
        static final ChildNameGeneratorImpl INSTANCE = new ChildNameGeneratorImpl();

        @CheckForNull
        public String itemNameFromItem(@NonNull MultiBranchProject<P, R> parent, @NonNull P item) {
            BranchProjectFactory<P, R> factory = parent.getProjectFactory();
            if (factory.isProject((Item)item)) {
                return NameEncoder.encode(factory.getBranch(item).getName());
            }
            String idealName = this.idealNameFromItem((AbstractFolder)parent, (TopLevelItem)item);
            if (idealName != null) {
                return NameEncoder.encode(idealName);
            }
            return null;
        }

        @CheckForNull
        public String dirNameFromItem(@NonNull MultiBranchProject<P, R> parent, @NonNull P item) {
            BranchProjectFactory<P, R> factory = parent.getProjectFactory();
            if (factory.isProject((Item)item)) {
                return NameMangler.apply(factory.getBranch(item).getName());
            }
            String idealName = this.idealNameFromItem((AbstractFolder)parent, (TopLevelItem)item);
            if (idealName != null) {
                return NameMangler.apply(idealName);
            }
            return null;
        }

        @NonNull
        public String itemNameFromLegacy(@NonNull MultiBranchProject<P, R> parent, @NonNull String legacyDirName) {
            return NameEncoder.decode(legacyDirName);
        }

        @NonNull
        public String dirNameFromLegacy(@NonNull MultiBranchProject<P, R> parent, @NonNull String legacyDirName) {
            return NameMangler.apply(NameEncoder.decode(legacyDirName));
        }

        public void recordLegacyName(MultiBranchProject<P, R> parent, P item, String legacyDirName) throws IOException {
        }
    }
}

