/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.views.AbstractFolderViewHolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ListView;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.DescribableList;
import hudson.views.DefaultViewsTabBar;
import hudson.views.JobColumn;
import hudson.views.ListViewColumn;
import hudson.views.StatusColumn;
import hudson.views.ViewsTabBar;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.branch.BranchCategoryFilter;
import jenkins.branch.BranchStatusColumn;
import jenkins.branch.ItemColumn;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHeadCategory;
import net.jcip.annotations.GuardedBy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.Authentication;

public class MultiBranchProjectViewHolder
extends AbstractFolderViewHolder {
    @NonNull
    private final MultiBranchProject<?, ?> owner;
    private transient ViewsTabBar tabBar;
    @GuardedBy(value="this")
    private volatile transient List<View> views = null;
    @GuardedBy(value="this")
    private volatile transient String primaryView = null;

    public MultiBranchProjectViewHolder(MultiBranchProject<?, ?> owner) {
        this.owner = owner;
    }

    @NonNull
    public List<View> getViews() {
        if (!this.owner.hasVisibleItems()) {
            return Collections.singletonList(this.owner.getWelcomeView());
        }
        this.ensureViews();
        return this.views;
    }

    public void setViews(@NonNull List<? extends View> views) {
    }

    public String getPrimaryView() {
        if (!this.owner.hasVisibleItems()) {
            return "welcome";
        }
        this.ensureViews();
        return this.primaryView;
    }

    public void setPrimaryView(@CheckForNull String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureViews() {
        if (this.views == null) {
            MultiBranchProjectViewHolder multiBranchProjectViewHolder = this;
            synchronized (multiBranchProjectViewHolder) {
                if (this.views == null) {
                    ArrayList<View> views = new ArrayList<View>();
                    for (SCMHeadCategory c : SCMHeadCategory.collectAndSimplify(this.owner.getSCMSources()).values()) {
                        views.add((View)new ViewImpl((ViewGroup)this.owner, c));
                        if (!c.isUncategorized()) continue;
                        this.primaryView = c.getName();
                    }
                    this.views = views;
                }
            }
        }
    }

    public boolean isPrimaryModifiable() {
        return false;
    }

    @NonNull
    public ViewsTabBar getTabBar() {
        if (this.tabBar == null) {
            this.tabBar = new DefaultViewsTabBar();
        }
        return this.tabBar;
    }

    public void setTabBar(@NonNull ViewsTabBar tabBar) {
    }

    public boolean isTabBarModifiable() {
        return false;
    }

    public synchronized void invalidateCaches() {
        this.views = null;
        this.primaryView = null;
    }

    @Restricted(value={NoExternalUse.class})
    public static class ViewImpl
    extends ListView {
        @NonNull
        private final SCMHeadCategory category;

        public ViewImpl(ViewGroup owner, @NonNull SCMHeadCategory category) {
            super(category.getName(), owner);
            this.category = category;
            try {
                this.getJobFilters().replaceBy(Collections.singletonList(new BranchCategoryFilter(category)));
                DescribableList columns = this.getColumns();
                columns.replace((Object)((ListViewColumn)columns.get(StatusColumn.class)), (Object)new BranchStatusColumn());
                columns.replace((Object)((ListViewColumn)columns.get(JobColumn.class)), (Object)new ItemColumn());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setRecurse(false);
        }

        public String getDisplayName() {
            return String.valueOf(this.category.getDisplayName()) + " (" + this.getItems().size() + ")";
        }

        public boolean isRecurse() {
            return false;
        }

        @NonNull
        public ACL getACL() {
            final ACL acl = super.getACL();
            return new ACL(){

                public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
                    if (View.CREATE.equals((Object)permission) || View.CONFIGURE.equals((Object)permission) || View.DELETE.equals((Object)permission)) {
                        return false;
                    }
                    return acl.hasPermission2(a, permission);
                }
            };
        }

        public void save() throws IOException {
        }

        @Extension
        public static class ViewDescriptorImpl
        extends ViewDescriptor {
            @NonNull
            public String getDisplayName() {
                return "Multibranch Project All view";
            }

            public boolean isInstantiable() {
                return false;
            }
        }
    }
}

