/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.slaves.ComputerListener;
import hudson.slaves.WorkspaceList;
import hudson.util.ClassLoaderSanityThreadFactory;
import hudson.util.DaemonThreadFactory;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.NamingThreadFactory;
import hudson.util.TextFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.MasterToSlaveFileCallable;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.security.ImpersonatingExecutorService;
import jenkins.slaves.WorkspaceLocator;
import jenkins.util.ContextResettingExecutorService;
import jenkins.util.ErrorLoggingExecutorService;
import jenkins.util.SystemProperties;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.Authentication;

@Restricted(value={NoExternalUse.class})
@Extension(ordinal=-100.0)
public class WorkspaceLocatorImpl
extends WorkspaceLocator {
    private static final Logger LOGGER = Logger.getLogger(WorkspaceLocatorImpl.class.getName());
    @Deprecated
    static final int PATH_MAX_DEFAULT = 80;
    @Deprecated
    static int PATH_MAX = Integer.getInteger(WorkspaceLocatorImpl.class.getName() + ".PATH_MAX", 80);
    static int MAX_LENGTH = Integer.getInteger(WorkspaceLocatorImpl.class.getName() + ".MAX_LENGTH", 32);
    static Mode MODE = Mode.valueOf(System.getProperty(WorkspaceLocatorImpl.class.getName() + ".MODE", Mode.MULTIBRANCH_ONLY.name()));
    static final String INDEX_FILE_NAME = "workspaces.txt";
    private static final String COMBINATOR = System.getProperty(WorkspaceList.class.getName(), "@");
    private final Map<VirtualChannel, IndexCacheEntry> indexCache = new WeakHashMap<VirtualChannel, IndexCacheEntry>();
    private final LoadingCache<Node, Object> nodeLocks = Caffeine.newBuilder().weakKeys().build(node -> "WorkspaceLocatorImpl lock for " + node.getNodeName());
    private static final Pattern GOOD_RAW_WORKSPACE_DIR = Pattern.compile("(.+)[/\\\\][$][{]ITEM_FULL_?NAME[}][/\\\\]?");

    public FilePath locate(TopLevelItem item, Node node) {
        return WorkspaceLocatorImpl.locate(item, node, true);
    }

    private static FilePath locate(TopLevelItem item, Node node, boolean create) {
        return WorkspaceLocatorImpl.locate(item, item.getFullName(), node, create);
    }

    @CheckForNull
    private static FilePath locate(TopLevelItem item, String fullName, Node node, boolean create) {
        FilePath workspace;
        switch (MODE) {
            case DISABLED: {
                LOGGER.log(Level.FINE, "disabled, skipping for {0} on {1}", new Object[]{item, node});
                return null;
            }
            case MULTIBRANCH_ONLY: {
                if (item.getParent() instanceof MultiBranchProject) break;
                LOGGER.log(Level.FINE, "ignoring non-branch project {0} on {1}", new Object[]{item, node});
                return null;
            }
            case ENABLED: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if ((workspace = WorkspaceLocatorImpl.getWorkspaceRoot(node)) == null) {
            LOGGER.log(Level.FINE, "no available workspace root for {0} so skipping {1}", new Object[]{node, item});
            return null;
        }
        if (fullName.contains("\n") || fullName.equals(INDEX_FILE_NAME)) {
            throw new IllegalArgumentException("Dangerous job name `" + fullName + "`");
        }
        try {
            Object object = WorkspaceLocatorImpl.lockFor(node);
            synchronized (object) {
                FilePath dir;
                Map<String, String> index = WorkspaceLocatorImpl.load(workspace);
                String path = index.get(fullName);
                if (path != null) {
                    FilePath dir2 = workspace.child(path);
                    LOGGER.log(Level.FINER, "index already lists {0} for {1} on {2}", new Object[]{dir2, item, node});
                    return dir2;
                }
                if (PATH_MAX != 0 && item.getParent() instanceof MultiBranchProject && (dir = workspace.child(path = WorkspaceLocatorImpl.minimize(fullName))).isDirectory()) {
                    index.put(fullName, path);
                    WorkspaceLocatorImpl.save(index, workspace);
                    LOGGER.log(Level.FINE, "detected existing workspace {0} under old naming scheme for {1} on {2}", new Object[]{dir, item, node});
                    return dir;
                }
                dir = workspace.child(fullName);
                if (dir.isDirectory()) {
                    index.put(fullName, fullName);
                    WorkspaceLocatorImpl.save(index, workspace);
                    LOGGER.log(Level.FINE, "using plain default location {0} for {1} on {2}", new Object[]{dir, item, node});
                    return dir;
                }
                if (!create) {
                    LOGGER.log(Level.FINE, "not creating a new workspace for {0} on {1} since {2} does not exist", new Object[]{item, node, dir});
                    return null;
                }
                String mnemonic = WorkspaceLocatorImpl.mnemonicOf(fullName);
                int i = 1;
                while (true) {
                    path = StringUtils.right((String)(i > 1 ? mnemonic + "_" + i : mnemonic), (int)MAX_LENGTH);
                    if (index.containsValue(path = WorkspaceLocatorImpl.replaceLeadingHyphen(path))) {
                        LOGGER.log(Level.FINER, "index collision on {0} for {1} on {2}", new Object[]{path, item, node});
                    } else {
                        dir = workspace.child(path);
                        if (dir.isDirectory()) {
                            LOGGER.log(Level.FINER, "directory collision on {0} for {1} on {2}", new Object[]{path, item, node});
                        } else {
                            index.put(fullName, path);
                            WorkspaceLocatorImpl.save(index, workspace);
                            LOGGER.log(Level.FINE, "allocating {0} for {1} on {2}", new Object[]{dir, item, node});
                            return dir;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException | InterruptedException x) {
            LOGGER.log(Level.WARNING, "could not manage workspaces on " + String.valueOf(node), x);
            return null;
        }
    }

    private static Map<VirtualChannel, IndexCacheEntry> indexCache() {
        return ((WorkspaceLocatorImpl)((Object)ExtensionList.lookupSingleton(WorkspaceLocatorImpl.class))).indexCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> load(FilePath workspace) throws IOException, InterruptedException {
        IndexCacheEntry entry;
        Map<VirtualChannel, IndexCacheEntry> _indexCache;
        Map<VirtualChannel, IndexCacheEntry> map = _indexCache = WorkspaceLocatorImpl.indexCache();
        synchronized (map) {
            entry = _indexCache.get(workspace.getChannel());
        }
        if (entry != null && entry.workspaceRoot.equals(workspace.getRemote())) {
            LOGGER.log(Level.FINER, "cache hit on {0}", workspace);
            return entry.index;
        }
        LOGGER.log(Level.FINER, "cache miss on {0}", workspace);
        TreeMap<String, String> map2 = new TreeMap<String, String>();
        FilePath index = workspace.child(INDEX_FILE_NAME);
        if (index.exists()) {
            try (InputStream is = index.read();
                 InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(r);){
                String key;
                while ((key = br.readLine()) != null) {
                    String value = br.readLine();
                    if (value == null) {
                        throw new IOException("malformed " + String.valueOf(index));
                    }
                    map2.put(key, value);
                }
            }
        }
        Map<VirtualChannel, IndexCacheEntry> map3 = _indexCache;
        synchronized (map3) {
            _indexCache.put(workspace.getChannel(), new IndexCacheEntry(workspace.getRemote(), map2));
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(Map<String, String> index, FilePath workspace) throws IOException, InterruptedException {
        Map<VirtualChannel, IndexCacheEntry> _indexCache;
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, String> entry : index.entrySet()) {
            b.append(entry.getKey()).append('\n').append(entry.getValue()).append('\n');
        }
        workspace.child(INDEX_FILE_NAME).act((FilePath.FileCallable)new WriteAtomic(b.toString()));
        LOGGER.log(Level.FINER, "cache update on {0}", workspace);
        Map<VirtualChannel, IndexCacheEntry> map = _indexCache = WorkspaceLocatorImpl.indexCache();
        synchronized (map) {
            _indexCache.put(workspace.getChannel(), new IndexCacheEntry(workspace.getRemote(), index));
        }
    }

    private static Object lockFor(Node node) {
        return ((WorkspaceLocatorImpl)((Object)ExtensionList.lookupSingleton(WorkspaceLocatorImpl.class))).nodeLocks.get((Object)node);
    }

    @CheckForNull
    static FilePath getWorkspaceRoot(Node node) {
        if (node instanceof Jenkins) {
            String rawWorkspaceDir = ((Jenkins)node).getRawWorkspaceDir();
            Matcher m = GOOD_RAW_WORKSPACE_DIR.matcher(rawWorkspaceDir);
            if (m.matches()) {
                return new FilePath(new File(m.group(1).replace("${JENKINS_HOME}", ((Jenkins)node).getRootDir().getAbsolutePath())));
            }
            LOGGER.fine(() -> "JENKINS-2111 path sanitization ineffective when using Workspace Root Directory " + rawWorkspaceDir + "; switch to ${JENKINS_HOME}/workspace/${ITEM_FULL_NAME} as in JENKINS-8446 / JENKINS-21942");
            return null;
        }
        if (node instanceof Slave) {
            return ((Slave)node).getWorkspaceRoot();
        }
        LOGGER.log(Level.WARNING, "Unrecognized node {0} of {1}", new Object[]{node, node.getClass()});
        return null;
    }

    @Deprecated
    private static String uniqueSuffix(String name) {
        byte[] sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256").digest(name.getBytes(StandardCharsets.UTF_16LE));
        }
        catch (NoSuchAlgorithmException x) {
            throw new AssertionError("https://docs.oracle.com/javase/7/docs/technotes/guides/security/StandardNames.html#MessageDigest", x);
        }
        return new Base32(0).encodeToString(sha256).replaceFirst("=+$", "");
    }

    private static String mnemonicOf(String name) {
        return name.replaceAll("(%[0-9A-F]{2}|[^a-zA-Z0-9-_.])+", "_");
    }

    private static String replaceLeadingHyphen(String name) {
        return name.replaceAll("^-", "_");
    }

    @Deprecated
    static String minimize(String name) {
        String mnemonic = WorkspaceLocatorImpl.mnemonicOf(name);
        int maxSuffix = 53;
        int maxMnemonic = Math.max(PATH_MAX - maxSuffix, 1);
        if (maxSuffix + maxMnemonic > PATH_MAX) {
            LOGGER.log(Level.WARNING, "WorkspaceLocatorImpl.PATH_MAX is small enough that workspace path collisions are more likely to occur");
            int minSuffix = 11;
            maxMnemonic = Math.max((PATH_MAX - 11) / 2, 1);
            maxSuffix = Math.max(PATH_MAX - maxMnemonic, 11);
        }
        String result = StringUtils.right((String)mnemonic, (int)maxMnemonic) + "-" + WorkspaceLocatorImpl.uniqueSuffix(name).substring(0, --maxSuffix);
        return result;
    }

    static enum Mode {
        DISABLED,
        MULTIBRANCH_ONLY,
        ENABLED;

    }

    private static final class IndexCacheEntry {
        final String workspaceRoot;
        final Map<String, String> index;

        IndexCacheEntry(String workspaceRoot, Map<String, String> index) {
            this.workspaceRoot = workspaceRoot;
            this.index = index;
        }
    }

    private static final class WriteAtomic
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final String text;

        WriteAtomic(String text) {
            this.text = text;
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            new TextFile(f).write(this.text);
            return null;
        }
    }

    @Extension
    public static final class Collector
    extends ComputerListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
            Node node = c.getNode();
            if (node == null) {
                return;
            }
            FilePath workspace = WorkspaceLocatorImpl.getWorkspaceRoot(node);
            if (workspace == null) {
                return;
            }
            Object object = WorkspaceLocatorImpl.lockFor(node);
            synchronized (object) {
                Map<String, String> index = WorkspaceLocatorImpl.load(workspace);
                boolean modified = false;
                try (ACLContext as = ACL.as2((Authentication)ACL.SYSTEM2);){
                    Iterator<Map.Entry<String, String>> it = index.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, String> entry = it.next();
                        String fullName = entry.getKey();
                        if (Jenkins.get().getItemByFullName(fullName, TopLevelItem.class) != null) continue;
                        String path = entry.getValue();
                        it.remove();
                        modified = true;
                        for (FilePath child : workspace.listDirectories()) {
                            String childName = child.getName();
                            if (!childName.equals(path) && !childName.startsWith(path + COMBINATOR)) continue;
                            listener.getLogger().println("deleting obsolete workspace " + String.valueOf(child));
                            try {
                                child.deleteRecursive();
                            }
                            catch (IOException x) {
                                if (x.getSuppressed().length != 0) {
                                    IOException e = new IOException(x.getMessage(), x.getCause());
                                    e.setStackTrace(x.getStackTrace());
                                    LOGGER.log(Level.WARNING, "could not delete workspace " + String.valueOf(child) + " on " + node.getNodeName() + " check finer logs for more information", e);
                                    LOGGER.log(Level.FINE, "could not delete workspace " + String.valueOf(child) + " on " + node.getNodeName(), x);
                                } else {
                                    LOGGER.log(Level.WARNING, "could not delete workspace " + String.valueOf(child) + " on " + node.getNodeName(), x);
                                }
                                listener.getLogger().println("could not delete workspace " + String.valueOf(child) + " on " + node.getNodeName() + " , wrong file ownership? Review exception in jenkins log and manually remove the directory");
                            }
                        }
                    }
                }
                if (modified) {
                    WorkspaceLocatorImpl.save(index, workspace);
                }
            }
        }
    }

    @Extension
    public static class Deleter
    extends ItemListener {
        private static final int CLEANUP_THREAD_LIMIT = SystemProperties.getInteger((String)(Deleter.class.getName() + ".CLEANUP_THREAD_LIMIT"), (Integer)0);
        private static final ExecutorService executorService = Deleter.executorService();
        private static int runningTasks;

        private static ExecutorService executorService() {
            if (CLEANUP_THREAD_LIMIT > 0) {
                ThreadPoolExecutor tpe = new ThreadPoolExecutor(CLEANUP_THREAD_LIMIT, CLEANUP_THREAD_LIMIT, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new ExceptionCatchingThreadFactory((ThreadFactory)new NamingThreadFactory((ThreadFactory)new ClassLoaderSanityThreadFactory((ThreadFactory)new DaemonThreadFactory()), "Deleter.cleanupTask")));
                tpe.allowCoreThreadTimeOut(true);
                return new ContextResettingExecutorService((ExecutorService)new ImpersonatingExecutorService((ExecutorService)new ErrorLoggingExecutorService((ExecutorService)tpe), ACL.SYSTEM2));
            }
            return Computer.threadPoolForRemoting;
        }

        public void onDeleted(Item item) {
            if (!(item instanceof TopLevelItem)) {
                return;
            }
            TopLevelItem tli = (TopLevelItem)item;
            Jenkins jenkins = Jenkins.get();
            Queue nodes = Stream.concat(Stream.of(jenkins), jenkins.getNodes().stream()).collect(Collectors.toCollection(LinkedList::new));
            try {
                while (!nodes.isEmpty()) {
                    executorService.execute(new CleanupTask(tli, (Node)nodes.remove()));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage());
            }
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            if (!(item instanceof TopLevelItem)) {
                return;
            }
            Jenkins jenkins = Jenkins.get();
            Computer.threadPoolForRemoting.submit(new MoveTask(oldFullName, newFullName, (Node)jenkins));
            for (Node node : jenkins.getNodes()) {
                Computer.threadPoolForRemoting.submit(new MoveTask(oldFullName, newFullName, node));
            }
        }

        static synchronized void waitForTasksToFinish() throws InterruptedException {
            while (runningTasks > 0) {
                Deleter.class.wait();
            }
        }

        private static synchronized void taskStarted() {
            ++runningTasks;
        }

        private static synchronized void taskFinished() {
            --runningTasks;
            Deleter.class.notifyAll();
        }

        private static class CleanupTask
        implements Runnable {
            @NonNull
            private final TopLevelItem tli;
            @NonNull
            private final Node node;

            CleanupTask(TopLevelItem tli, Node node) {
                this.tli = tli;
                this.node = node;
                Deleter.taskStarted();
            }

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }

        private static class MoveTask
        implements Runnable {
            @NonNull
            private final String oldFullName;
            @NonNull
            private final String newFullName;
            @NonNull
            private final Node node;

            MoveTask(String oldFullName, String newFullName, Node node) {
                this.oldFullName = oldFullName;
                this.newFullName = newFullName;
                this.node = node;
                Deleter.taskStarted();
            }

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
    }
}

