/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.buildwrapper;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ConfigFile;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.utils.ConfigFileDetailLinkDescription;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class ManagedFile
extends ConfigFile
implements ExtensionPoint,
Describable<ManagedFile>,
Serializable {
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public String variable;

    @DataBoundConstructor
    public ManagedFile(String fileId) {
        super(fileId, null, false);
    }

    public ManagedFile(String fileId, String targetLocation, String variable, Boolean replaceTokens) {
        super(fileId, targetLocation, replaceTokens);
        this.variable = Util.fixEmptyAndTrim((String)variable);
    }

    public ManagedFile(String fileId, String targetLocation, String variable) {
        super(fileId, targetLocation, false);
        this.variable = Util.fixEmptyAndTrim((String)variable);
    }

    @DataBoundSetter
    public void setTargetLocation(String targetLocation) {
        this.targetLocation = Util.fixEmptyAndTrim((String)targetLocation);
    }

    public String getVariable() {
        return this.variable;
    }

    @DataBoundSetter
    public void setVariable(String variable) {
        this.variable = Util.fixEmptyAndTrim((String)variable);
    }

    @DataBoundSetter
    public void setReplaceTokens(Boolean replaceTokens) {
        this.replaceTokens = replaceTokens != null ? replaceTokens : false;
    }

    public String toString() {
        return "[ManagedFile: id=" + this.getFileId() + ", targetLocation=" + this.getTargetLocation() + ", variable=" + this.variable + "]";
    }

    public Descriptor<ManagedFile> getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    @Symbol(value={"configFile"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ManagedFile> {
        public String getDisplayName() {
            return "";
        }

        public ListBoxModel doFillFileIdItems(@AncestorInPath ItemGroup context, @AncestorInPath Item project, @AncestorInPath AccessControlled ac) {
            if (project != null) {
                project.checkPermission(Item.CONFIGURE);
            } else {
                ac.checkPermission(Item.CREATE);
            }
            ListBoxModel items = new ListBoxModel();
            items.add("please select", "");
            for (Config config : ConfigFiles.getConfigsInContext(context, null)) {
                items.add(config.name, config.id);
            }
            return items;
        }

        public HttpResponse doCheckFileId(StaplerRequest2 req, @AncestorInPath Item context, @AncestorInPath AccessControlled ac, @QueryParameter String fileId) {
            if (context != null) {
                context.checkPermission(Item.CONFIGURE);
            } else {
                ac.checkPermission(Item.CREATE);
            }
            if (context == null) {
                Object config = ConfigFiles.getByIdOrNull((ItemGroup)Jenkins.get(), fileId);
                return config != null ? FormValidation.ok() : FormValidation.error((String)"The selected file is invalid");
            }
            Object config = ConfigFiles.getByIdOrNull(context, fileId);
            if (config != null) {
                return ConfigFileDetailLinkDescription.getDescription(req, context, fileId);
            }
            return FormValidation.error((String)"The selected file is incorrect.");
        }
    }
}

