/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.jenkinsci.plugins.configfiles.maven.security.HasServerCredentialMappings;

public abstract class AbstractMavenSettingsProvider
extends AbstractConfigProviderImpl {
    @Override
    public ContentType getContentType() {
        return ContentType.DefinedType.XML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadTemplateContent() {
        InputStream in = null;
        try {
            in = AbstractMavenSettingsProvider.class.getResourceAsStream("settings-tpl.xml");
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            String string = "<settings></settings>";
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public String supplyContent(Config configFile, Run<?, ?> build, FilePath workDir, TaskListener listener, List<String> tempFiles) throws IOException {
        HasServerCredentialMappings settings = (HasServerCredentialMappings)((Object)configFile);
        Map<String, StandardUsernameCredentials> resolvedCredentials = CredentialsHelper.resolveCredentials(build, settings.getServerCredentialMappings(), listener);
        Boolean isReplaceAll = settings.getIsReplaceAll();
        String fileContent = super.supplyContent(configFile, build, workDir, listener, tempFiles);
        if (!resolvedCredentials.isEmpty()) {
            try {
                fileContent = CredentialsHelper.fillAuthentication(fileContent, isReplaceAll, resolvedCredentials, workDir, tempFiles);
            }
            catch (Exception exception) {
                throw new IOException("[ERROR] could not insert credentials into the settings file " + configFile, exception);
            }
        }
        return fileContent;
    }

    @Override
    @NonNull
    public List<String> getSensitiveContentForMasking(Config configFile, Run<?, ?> build) {
        HasServerCredentialMappings settings = (HasServerCredentialMappings)((Object)configFile);
        return CredentialsHelper.secretsForMasking(build, settings.getServerCredentialMappings());
    }
}

