/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.properties.security;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.configfiles.properties.security.PropertiesCredentialMapping;
import org.jenkinsci.plugins.configfiles.properties.security.PropertyKeyRequirement;

public class CredentialsHelper {
    private static final Logger LOGGER = Logger.getLogger(CredentialsHelper.class.getName());

    private CredentialsHelper() {
    }

    public static Map<String, StandardUsernameCredentials> resolveCredentials(Run<?, ?> build, List<PropertiesCredentialMapping> propertiesCredentialMappings, TaskListener listener) {
        HashMap<String, StandardUsernameCredentials> propertiesCredentialsMap = new HashMap<String, StandardUsernameCredentials>();
        for (PropertiesCredentialMapping propertiesCredentialMapping : propertiesCredentialMappings) {
            StandardUsernameCredentials c;
            String credentialsId = propertiesCredentialMapping.getCredentialsId();
            String propertyKey = propertiesCredentialMapping.getPropertyKey();
            List<Object> domainRequirements = Collections.emptyList();
            if (StringUtils.isNotBlank((String)propertyKey)) {
                domainRequirements = Collections.singletonList(new PropertyKeyRequirement(propertyKey));
            }
            if ((c = (StandardUsernameCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernameCredentials.class, build, domainRequirements)) != null) {
                propertiesCredentialsMap.put(propertyKey, c);
                continue;
            }
            listener.getLogger().println("Could not find credentials [" + credentialsId + "] for " + build);
        }
        return propertiesCredentialsMap;
    }

    public static String fillAuthentication(String propertiesContent, Boolean isReplaceAllPropertyDefinitions, Map<String, StandardUsernameCredentials> propertiesCredentialsMap) {
        String content = propertiesContent;
        ArrayList<String> propertiesArray = new ArrayList<String>();
        propertiesArray.addAll(Arrays.asList(content.split("[\\r\\n]+")));
        for (int index = 0; index < propertiesArray.size(); ++index) {
            String[] propertyParts;
            String property = (String)propertiesArray.get(index);
            if (!property.contains("=") || !propertiesCredentialsMap.containsKey((propertyParts = property.split("="))[0])) continue;
            if (isReplaceAllPropertyDefinitions.booleanValue()) {
                StandardUsernameCredentials credential = propertiesCredentialsMap.get(propertyParts[0]);
                propertiesArray.set(index, CredentialsHelper.createCredentialBasedProperty(propertyParts[0], credential));
                continue;
            }
            propertiesCredentialsMap.remove(propertyParts[0]);
        }
        propertiesCredentialsMap.forEach((key, value) -> propertiesArray.add(CredentialsHelper.createCredentialBasedProperty(key, value)));
        content = String.join((CharSequence)"\r\n", propertiesArray);
        StringWriter writer = new StringWriter();
        writer.write(content);
        content = writer.toString();
        return content;
    }

    private static String createCredentialBasedProperty(String propertyKey, StandardUsernameCredentials credential) {
        String propertyValue = "";
        if (credential instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials usernamePasswordCredentials = (StandardUsernamePasswordCredentials)credential;
            propertyValue = usernamePasswordCredentials.getPassword().getPlainText();
        } else if (credential instanceof SSHUserPrivateKey) {
            SSHUserPrivateKey sshUserPrivateKey = (SSHUserPrivateKey)credential;
            List privateKeys = sshUserPrivateKey.getPrivateKeys();
            if (privateKeys.isEmpty()) {
                LOGGER.log(Level.WARNING, "Property {0}: not private key defined in {1}, skip", new Object[]{propertyKey, sshUserPrivateKey.getId()});
            } else if (privateKeys.size() == 1) {
                LOGGER.log(Level.FINE, "Property {0}: use {1}", new Object[]{propertyKey, sshUserPrivateKey.getId()});
                propertyValue = (String)privateKeys.get(0);
            } else {
                LOGGER.log(Level.WARNING, "Property {0}: more than one ({1}) private key defined in {1}, use first private key", new Object[]{propertyKey, privateKeys.size(), sshUserPrivateKey.getId()});
                propertyValue = (String)privateKeys.get(0);
            }
        } else {
            LOGGER.log(Level.WARNING, "Property {0}: credentials type of {1} not supported: {2}", new Object[]{propertyKey, credential == null ? null : credential.getId(), credential == null ? null : credential.getClass()});
        }
        return propertyKey + "=" + propertyValue;
    }

    @NonNull
    public static List<String> secretsForMasking(Run<?, ?> build, List<PropertiesCredentialMapping> propertiesCredentialMappings) {
        ArrayList<String> sensitiveStrings = new ArrayList<String>();
        Map<String, StandardUsernameCredentials> resolveCredentials = CredentialsHelper.resolveCredentials(build, propertiesCredentialMappings, TaskListener.NULL);
        for (StandardUsernameCredentials credential : resolveCredentials.values()) {
            if (credential instanceof StandardUsernamePasswordCredentials) {
                sensitiveStrings.add(((StandardUsernamePasswordCredentials)credential).getPassword().getPlainText());
                continue;
            }
            if (!(credential instanceof SSHUserPrivateKey)) continue;
            SSHUserPrivateKey sshUserPrivateKey = (SSHUserPrivateKey)credential;
            List privateKeys = sshUserPrivateKey.getPrivateKeys();
            if (sshUserPrivateKey.getPrivateKeys().isEmpty()) continue;
            sensitiveStrings.add((String)privateKeys.get(0));
        }
        return sensitiveStrings;
    }
}

