/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.Messages;
import org.jenkinsci.plugins.credentialsbinding.impl.UnbindableDir;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CertificateMultiBinding
extends MultiBinding<StandardCertificateCredentials> {
    private final String keystoreVariable;
    private String passwordVariable;
    private String aliasVariable;

    public String getKeystoreVariable() {
        return this.keystoreVariable;
    }

    public String getPasswordVariable() {
        return this.passwordVariable;
    }

    public String getAliasVariable() {
        return this.aliasVariable;
    }

    @DataBoundSetter
    public void setPasswordVariable(String passwordVariable) {
        this.passwordVariable = passwordVariable;
    }

    @DataBoundSetter
    public void setAliasVariable(String aliasVariable) {
        this.aliasVariable = aliasVariable;
    }

    @DataBoundConstructor
    public CertificateMultiBinding(@NonNull String keystoreVariable, String credentialsId) {
        super(credentialsId);
        this.keystoreVariable = keystoreVariable;
    }

    @Override
    protected Class<StandardCertificateCredentials> type() {
        return StandardCertificateCredentials.class;
    }

    @Override
    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        StandardCertificateCredentials credentials = (StandardCertificateCredentials)this.getCredentials(build);
        String storePassword = credentials.getPassword().getPlainText();
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (this.aliasVariable != null && !this.aliasVariable.isEmpty()) {
            m.put(this.aliasVariable, credentials.getDescription());
        }
        if (this.passwordVariable != null && !this.passwordVariable.isEmpty()) {
            m.put(this.passwordVariable, storePassword);
        }
        if (workspace != null) {
            UnbindableDir secrets = UnbindableDir.create(workspace);
            FilePath secret = secrets.getDirPath().child("keystore-" + this.keystoreVariable);
            OutputStream out = secret.write();
            try {
                credentials.getKeyStore().store(out, storePassword.toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            secret.chmod(256);
            m.put(this.keystoreVariable, secret.getRemote());
            return new MultiBinding.MultiEnvironment(m, secrets.getUnbinder());
        }
        return new MultiBinding.MultiEnvironment(m);
    }

    @Override
    public Set<String> variables(@NonNull Run<?, ?> build) {
        HashSet<String> set = new HashSet<String>();
        set.add(this.keystoreVariable);
        if (this.aliasVariable != null && !this.aliasVariable.isEmpty()) {
            set.add(this.aliasVariable);
        }
        if (this.passwordVariable != null && !this.passwordVariable.isEmpty()) {
            set.add(this.passwordVariable);
        }
        return ImmutableSet.copyOf(set);
    }

    @Extension
    @Symbol(value={"certificate"})
    public static class DescriptorImpl
    extends BindingDescriptor<StandardCertificateCredentials> {
        @Override
        protected Class<StandardCertificateCredentials> type() {
            return StandardCertificateCredentials.class;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.CertificateMultiBinding_certificate_keystore();
        }
    }
}

