/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi.actions;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import java.util.Collection;
import jenkins.model.TransientActionFactory;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.actions.AbstractDisplayAction;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=0)
public class RunDisplayAction
extends AbstractDisplayAction {
    private final Run run;

    protected RunDisplayAction(Run run) {
        this.run = run;
    }

    @Exported(visibility=1)
    public String getArtifactsUrl() {
        return this.lookupProvider().getArtifactsURL(this.run);
    }

    @Exported(visibility=1)
    public String getChangesUrl() {
        return this.lookupProvider().getChangesURL(this.run);
    }

    @Exported(visibility=1)
    public String getTestsUrl() {
        return this.lookupProvider().getTestsURL(this.run);
    }

    @Exported(visibility=1)
    public String getDisplayUrl() {
        return this.lookupProvider().getRunURL(this.run);
    }

    @Override
    protected String getRedirectURL(DisplayURLProvider provider) {
        String url;
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        String page = req.getParameter("page");
        if (page != null) {
            switch (page) {
                case "artifacts": {
                    url = provider.getArtifactsURL(this.run);
                    break;
                }
                case "changes": {
                    url = provider.getChangesURL(this.run);
                    break;
                }
                case "tests": {
                    url = provider.getTestsURL(this.run);
                    break;
                }
                default: {
                    url = provider.getRunURL(this.run);
                    break;
                }
            }
        } else {
            url = provider.getRunURL(this.run);
        }
        return url;
    }

    @Extension
    public static class TransientActionFactoryImpl
    extends TransientActionFactory<Run> {
        public Class type() {
            return Run.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull Run target) {
            return ImmutableList.of((Object)new RunDisplayAction(target));
        }
    }
}

