/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.util.LineEndingConversion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public final class WindowsBatchScript
extends FileMonitoringTask {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean USE_BINARY_WRAPPER = Boolean.getBoolean(WindowsBatchScript.class.getName() + ".USE_BINARY_WRAPPER");
    private final String script;
    private boolean capturingOutput;
    private static final Logger LOGGER = Logger.getLogger(WindowsBatchScript.class.getName());
    private static final String LAUNCH_DIAGNOSTICS_PROP = WindowsBatchScript.class.getName() + ".LAUNCH_DIAGNOSTICS";
    private static boolean LAUNCH_DIAGNOSTICS = Boolean.getBoolean(LAUNCH_DIAGNOSTICS_PROP);

    @DataBoundConstructor
    public WindowsBatchScript(String script) {
        this.script = LineEndingConversion.convertEOL((String)script, (LineEndingConversion.EOLType)LineEndingConversion.EOLType.Windows);
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void captureOutput() {
        this.capturingOutput = true;
    }

    @Override
    protected FileMonitoringTask.FileMonitoringController doLaunch(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        FilePath binary;
        if (launcher.isUnix()) {
            throw new IOException("Batch scripts can only be run on Windows nodes");
        }
        BatchController c = new BatchController(ws, (String)envVars.get((Object)"JENKINS_SERVER_COOKIE"));
        List<String> launcherCmd = null;
        if (USE_BINARY_WRAPPER && (binary = WindowsBatchScript.requestBinary(ws, c)) != null) {
            launcherCmd = this.binaryLauncherCmd(c, ws, binary.getRemote(), c.getBatchFile2(ws).getRemote());
            c.getBatchFile2(ws).write(this.script, "UTF-8");
        }
        if (launcherCmd == null) {
            launcherCmd = this.scriptLauncherCmd(c, ws);
        }
        LOGGER.log(Level.FINE, "launching {0}", launcherCmd);
        Launcher.ProcStarter ps = launcher.launch().cmds(launcherCmd).envs(WindowsBatchScript.escape(envVars)).pwd(ws).quiet(true);
        ps.readStdout().readStderr();
        Proc p = ps.start();
        c.registerForCleanup(p.getStdout());
        c.registerForCleanup(p.getStderr());
        return c;
    }

    @NonNull
    private List<String> binaryLauncherCmd(BatchController c, FilePath ws, String binaryPath, String scriptPath) throws IOException, InterruptedException {
        String logFile = c.getLogFile(ws).getRemote();
        String resultFile = c.getResultFile(ws).getRemote();
        String outputFile = c.getOutputFile(ws).getRemote();
        String controlDirPath = c.controlDir(ws).getRemote();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(binaryPath);
        cmd.add("-daemon");
        cmd.add("-executable=cmd");
        cmd.add("-args=/C call \\\"" + scriptPath + "\\\"");
        cmd.add("-controldir=" + controlDirPath);
        cmd.add("-result=" + resultFile);
        cmd.add("-log=" + logFile);
        if (this.capturingOutput) {
            cmd.add("-output=" + outputFile);
        }
        if (LAUNCH_DIAGNOSTICS) {
            cmd.add("-debug");
        }
        return cmd;
    }

    @NonNull
    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="%n from master might be \\n")
    private List<String> scriptLauncherCmd(BatchController c, FilePath ws) throws IOException, InterruptedException {
        String cmdString = this.capturingOutput ? String.format("@echo off \r\ncmd /c call \"%s\" > \"%s\" 2> \"%s\"\r\necho %%ERRORLEVEL%% > \"%s\"\r\n", WindowsBatchScript.quote(c.getBatchFile2(ws)), WindowsBatchScript.quote(c.getOutputFile(ws)), WindowsBatchScript.quote(c.getLogFile(ws)), WindowsBatchScript.quote(c.getResultFile(ws))) : String.format("@echo off \r\ncmd /c call \"%s\" > \"%s\" 2>&1\r\necho %%ERRORLEVEL%% > \"%s\"\r\n", WindowsBatchScript.quote(c.getBatchFile2(ws)), WindowsBatchScript.quote(c.getLogFile(ws)), WindowsBatchScript.quote(c.getResultFile(ws)));
        c.getBatchFile1(ws).write(cmdString, "UTF-8");
        c.getBatchFile2(ws).write(this.script, "UTF-8");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(Arrays.asList("cmd", "/c", "\"\"" + c.getBatchFile1(ws).getRemote() + "\"\""));
        return cmd;
    }

    private static String quote(FilePath f) {
        return f.getRemote().replace("%", "%%");
    }

    private static final class BatchController
    extends FileMonitoringTask.FileMonitoringController {
        private static final long serialVersionUID = 1L;

        private BatchController(FilePath ws, @NonNull String cookieValue) throws IOException, InterruptedException {
            super(ws, cookieValue);
        }

        public FilePath getBatchFile1(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("jenkins-wrap.bat");
        }

        public FilePath getBatchFile2(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("jenkins-main.bat");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.WindowsBatchScript_windows_batch();
        }
    }
}

