/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.util.BuildData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

public class PathRestriction
extends GitSCMExtension {
    private final String includedRegions;
    private final String excludedRegions;
    private volatile transient List<Pattern> includedPatterns;
    private volatile transient List<Pattern> excludedPatterns;

    @Override
    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    @DataBoundConstructor
    public PathRestriction(String includedRegions, String excludedRegions) {
        this.includedRegions = includedRegions;
        this.excludedRegions = excludedRegions;
    }

    public String getIncludedRegions() {
        return this.includedRegions;
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.normalize(this.excludedRegions);
    }

    public String[] getIncludedRegionsNormalized() {
        return this.normalize(this.includedRegions);
    }

    private String[] normalize(String s) {
        if (s == null || s.isBlank()) {
            return null;
        }
        return s.split("[\\r\\n]+");
    }

    private List<Pattern> getIncludedPatterns() {
        if (this.includedPatterns == null) {
            this.includedPatterns = this.getRegionsPatterns(this.getIncludedRegionsNormalized());
        }
        return this.includedPatterns;
    }

    private List<Pattern> getExcludedPatterns() {
        if (this.excludedPatterns == null) {
            this.excludedPatterns = this.getRegionsPatterns(this.getExcludedRegionsNormalized());
        }
        return this.excludedPatterns;
    }

    private List<Pattern> getRegionsPatterns(String[] regions) {
        if (regions != null) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>(regions.length);
            for (String region : regions) {
                patterns.add(Pattern.compile(region));
            }
            return patterns;
        }
        return Collections.emptyList();
    }

    @Override
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="null used to indicate other extensions should decide")
    @CheckForNull
    public Boolean isRevExcluded(GitSCM scm, GitClient git, GitChangeSet commit, TaskListener listener, BuildData buildData) {
        Collection<String> paths = commit.getAffectedPaths();
        if (paths.isEmpty()) {
            return null;
        }
        List<Pattern> included = this.getIncludedPatterns();
        List<Pattern> excluded = this.getExcludedPatterns();
        ArrayList<String> includedPaths = new ArrayList<String>(paths.size());
        if (!included.isEmpty()) {
            block0: for (String path : paths) {
                for (Pattern pattern : included) {
                    if (!pattern.matcher(path).matches()) continue;
                    includedPaths.add(path);
                    continue block0;
                }
            }
        } else {
            includedPaths.addAll(paths);
        }
        ArrayList<String> excludedPaths = new ArrayList<String>();
        if (!excluded.isEmpty()) {
            block2: for (String path : includedPaths) {
                for (Pattern pattern : excluded) {
                    if (!pattern.matcher(path).matches()) continue;
                    excludedPaths.add(path);
                    continue block2;
                }
            }
        }
        if (excluded.isEmpty() && !included.isEmpty() && includedPaths.isEmpty()) {
            listener.getLogger().println("Ignored commit " + commit.getCommitId() + ": No paths matched included region whitelist");
            return true;
        }
        if (includedPaths.size() == excludedPaths.size()) {
            listener.getLogger().println("Ignored commit " + commit.getCommitId() + ": Found only excluded paths: " + String.join((CharSequence)", ", excludedPaths));
            return true;
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Polling ignores commits in certain paths";
        }
    }
}

