/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.instance_identity.pem;

import java.io.IOException;
import java.math.BigInteger;
import org.jenkinsci.main.modules.instance_identity.pem.DerParser;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Asn1Object {
    protected final int type;
    protected final int length;
    protected final byte[] value;
    protected final int tag;

    public Asn1Object(int tag, int length, byte[] value) {
        this.tag = tag;
        this.type = tag & 0x1F;
        this.length = length;
        this.value = (byte[])value.clone();
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public DerParser getParser() throws IOException {
        if (!this.isConstructed()) {
            throw new IOException("Invalid DER: can't parse primitive entity");
        }
        return new DerParser(this.value);
    }

    public BigInteger getInteger() throws IOException {
        if (this.type != 2) {
            throw new IOException("Invalid DER: object is not integer");
        }
        return new BigInteger(this.value);
    }

    public String getString() throws IOException {
        return new String(this.value, switch (this.type) {
            case 18, 19, 21, 22, 25, 26, 27 -> "ISO-8859-1";
            case 30 -> "UTF-16BE";
            case 12 -> "UTF-8";
            case 28 -> throw new IOException("Invalid DER: can't handle UCS-4 string");
            default -> throw new IOException("Invalid DER: object is not a string");
        });
    }
}

