/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.actions.traverse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.actions.path.PathDelimiter;
import net.minidev.json.actions.traverse.JSONTraverseAction;

public class RetainPathsJsonAction
implements JSONTraverseAction {
    protected final PathDelimiter delim;
    protected JSONObject result;
    protected List<String> pathsToRetain;

    public RetainPathsJsonAction(List<String> pathsToRetain, PathDelimiter delim) {
        this.pathsToRetain = new ArrayList<String>(pathsToRetain);
        this.delim = delim;
    }

    @Override
    public boolean start(JSONObject object) {
        if (object == null) {
            this.result = null;
            return false;
        }
        if (this.pathsToRetain == null || this.pathsToRetain.size() == 0) {
            this.result = new JSONObject();
            return false;
        }
        this.result = object;
        return true;
    }

    @Override
    public boolean traverseEntry(String fullPathToEntry, Map.Entry<String, Object> entry) {
        return true;
    }

    @Override
    public boolean recurInto(String fullPathToSubtree, JSONObject entryValue) {
        return true;
    }

    @Override
    public boolean recurInto(String fullPathToArrayItem, JSONArray entryValue) {
        return true;
    }

    @Override
    public void handleLeaf(String pathToEntry, Map.Entry<String, Object> entry) {
    }

    @Override
    public void handleLeaf(String fullPathToContainingList, int listIndex, Object listItem) {
    }

    @Override
    public boolean removeEntry(String fullPathToEntry, Map.Entry<String, Object> entry) {
        return this.discardPath(fullPathToEntry, entry);
    }

    @Override
    public void end() {
    }

    @Override
    public Object result() {
        return this.result;
    }

    protected boolean discardPath(String pathToEntry, Map.Entry<String, Object> entry) {
        return !this.foundAsPrefix(pathToEntry) || !this.delim.accept(entry.getKey());
    }

    protected boolean foundAsPrefix(String path) {
        for (String p : this.pathsToRetain) {
            if (p != path && (p == null || path == null || !p.startsWith(path))) continue;
            return true;
        }
        return false;
    }
}

