/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mina_sshd_api.core.authenticators;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticatorFactory;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Functions;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.security.SecurityUtils;

public class MinaSSHPublicKeyAuthenticator
extends SSHAuthenticator<ClientSession, SSHUserPrivateKey> {
    static int authTimeout = Integer.parseInt(System.getProperty(MinaSSHPublicKeyAuthenticator.class.getName() + ".authTimeout", "15"));

    MinaSSHPublicKeyAuthenticator(@NonNull ClientSession connection, @NonNull SSHUserPrivateKey user, @CheckForNull String username) {
        super((Object)connection, (StandardUsernameCredentials)user, username);
    }

    public boolean canAuthenticate() {
        return ((ClientSession)this.getConnection()).getUserAuthFactories().stream().anyMatch(userAuthFactory -> userAuthFactory instanceof UserAuthPublicKeyFactory) && !((ClientSession)this.getConnection()).isAuthenticated() && ((ClientSession)this.getConnection()).isOpen();
    }

    @NonNull
    public SSHAuthenticator.Mode getAuthenticationMode() {
        return SSHAuthenticator.Mode.AFTER_CONNECT;
    }

    protected boolean doAuthenticate() {
        SSHUserPrivateKey user = (SSHUserPrivateKey)this.getUser();
        for (String key : user.getPrivateKeys()) {
            try {
                Secret passphrase = user.getPassphrase();
                Path path = Paths.get("key", new String[0]);
                SecurityUtils.loadKeyPairIdentities(null, (NamedResource)new PathResource(path), (InputStream)new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8)), passphrase == null ? null : FilePasswordProvider.of((String)passphrase.getPlainText())).forEach(keyPair -> ((ClientSession)this.getConnection()).addPublicKeyIdentity(keyPair));
                ((ClientSession)this.getConnection()).setUsername(this.getUsername());
                return ((AuthFuture)((ClientSession)this.getConnection()).auth().verify((long)authTimeout, TimeUnit.SECONDS)).isSuccess();
            }
            catch (IOException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)this.getListener().error("Could not authenticate due to I/O issue"));
            }
            catch (GeneralSecurityException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)this.getListener().error("Could not authenticate because unrecoverable key pair"));
            }
        }
        return false;
    }

    @Extension(optional=true)
    public static class Factory
    extends SSHAuthenticatorFactory {
        private static final long serialVersionUID = 1L;

        @Nullable
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user) {
            return this.newInstance(connection, user, null);
        }

        @Nullable
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user, @CheckForNull String username) {
            if (connection instanceof ClientSession && user instanceof SSHUserPrivateKey) {
                return new MinaSSHPublicKeyAuthenticator((ClientSession)connection, (SSHUserPrivateKey)user, username);
            }
            return null;
        }

        protected <C, U extends StandardUsernameCredentials> boolean supports(@NonNull Class<C> connectionClass, @NonNull Class<U> userClass) {
            return ClientSession.class.isAssignableFrom(connectionClass) && SSHUserPrivateKey.class.isAssignableFrom(userClass);
        }
    }
}

