/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.StageDirective;
import org.kohsuke.stapler.DataBoundConstructor;

public class StagesDirective
extends AbstractDirective<StagesDirective> {
    private List<StageDirective> stages;

    @DataBoundConstructor
    public StagesDirective(List<StageDirective> stages) {
        this.stages = stages;
    }

    public List<StageDirective> getStages() {
        return this.stages;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<StagesDirective> {
        @Override
        @NonNull
        public String getName() {
            return "stages";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Stages";
        }

        @Override
        @NonNull
        public List<Descriptor> getDescriptors() {
            ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
            descriptors.add(Jenkins.get().getDescriptorByType(StageDirective.DescriptorImpl.class));
            return descriptors;
        }

        @Override
        @NonNull
        public String toGroovy(@NonNull StagesDirective stages) {
            StringBuilder result = new StringBuilder("stages {\n");
            if (stages.stages != null) {
                stages.stages.stream().forEach(a -> result.append(a.toGroovy(false)).append("\n"));
            }
            result.append("}\n");
            return result.toString();
        }
    }
}

