/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveGenerator;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class ToolsDirective
extends AbstractDirective<ToolsDirective> {
    public static final String TOOLS_DELIMITER = "::::";
    private final List<SymbolAndName> tools = new ArrayList<SymbolAndName>();

    @DataBoundConstructor
    public ToolsDirective(List<SymbolAndName> tools) {
        if (tools != null) {
            this.tools.addAll(tools);
        }
    }

    public List<SymbolAndName> getTools() {
        return this.tools;
    }

    private List<ToolInstallation> getToolInstallations() {
        return this.tools.stream().map(ToolsDirective::installationFromParam).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static ToolInstallation installationFromParam(@NonNull SymbolAndName symbolAndName) {
        ToolDescriptor d;
        String symbol = symbolAndName.getSymbol();
        String name = symbolAndName.getName();
        if (!StringUtils.isEmpty((String)symbol) && !StringUtils.isEmpty((String)name) && (d = (ToolDescriptor)SymbolLookup.get().find(ToolDescriptor.class, symbol)) != null) {
            for (ToolInstallation t : d.getInstallations()) {
                if (!name.equals(t.getName())) continue;
                return t;
            }
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public static final class SymbolAndName {
        private String symbolAndName;
        private String symbol;
        private String name;

        @DataBoundConstructor
        public SymbolAndName(String symbolAndName) {
            String[] s = StringUtils.split((String)symbolAndName, (String)ToolsDirective.TOOLS_DELIMITER);
            this.symbol = s[0];
            this.name = s[1];
            this.symbolAndName = symbolAndName;
        }

        public String getSymbolAndName() {
            return this.symbolAndName;
        }

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<ToolsDirective> {
        @Override
        @NonNull
        public String getName() {
            return "tools";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Tools";
        }

        @Override
        @NonNull
        public List<Descriptor> getDescriptors() {
            return ExtensionList.lookup(ToolDescriptor.class).stream().filter(t -> t.getInstallations().length > 0 && DirectiveGenerator.getSymbolForDescriptor((Descriptor)t) != null).collect(Collectors.toList());
        }

        @Override
        @NonNull
        public String toGroovy(@NonNull ToolsDirective directive) {
            StringBuilder result = new StringBuilder("tools {\n");
            if (!directive.getTools().isEmpty()) {
                for (ToolInstallation tool : directive.getToolInstallations()) {
                    result.append(DirectiveGenerator.getSymbolForDescriptor(tool.getDescriptor())).append(" ");
                    result.append(Snippetizer.object2Groovy((Object)tool.getName())).append("\n");
                }
            } else {
                result.append("// No valid tools specified\n");
            }
            result.append("}\n");
            return result.toString();
        }
    }
}

