/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.steps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.pipeline.modeldefinition.model.CredentialsBindingHandler;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class CredentialWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String credentialId;
    private final List<Map<String, Object>> withCredentialsParameters;

    @Restricted(value={NoExternalUse.class})
    public CredentialWrapper(String credentialId, List<Map<String, Object>> withCredentialsParameters) {
        this.withCredentialsParameters = withCredentialsParameters;
        this.credentialId = credentialId;
    }

    @Whitelisted
    public String getCredentialId() {
        return this.credentialId;
    }

    @Whitelisted
    public void addParameters(String envVarName, List<Map<String, Object>> list) {
        list.addAll(this.resolveParameters(envVarName));
    }

    @Whitelisted
    public List<Map<String, Object>> resolveParameters(String envVarName) {
        ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>(this.withCredentialsParameters.size());
        for (Map<String, Object> params : this.withCredentialsParameters) {
            HashMap<String, Object> newP = new HashMap<String, Object>();
            for (Map.Entry<String, Object> p : params.entrySet()) {
                Object value = p.getValue();
                if (value instanceof CredentialsBindingHandler.EnvVarResolver) {
                    newP.put(p.getKey(), ((CredentialsBindingHandler.EnvVarResolver)value).resolve(envVarName));
                    continue;
                }
                newP.put(p.getKey(), p.getValue());
            }
            newList.add(newP);
        }
        return newList;
    }
}

