/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.StageAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.StageStep;
import org.jenkinsci.plugins.workflow.support.steps.stage.Messages;

public class StageStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(StageStepExecution.class.getName());
    private final transient StageStep step;
    private static final long serialVersionUID = 1L;

    StageStepExecution(StepContext context, StageStep step) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        if (this.step.concurrency != null) {
            throw new AbortException(Messages.StageStepExecution_concurrency_not_supported());
        }
        if (this.getContext().hasBody()) {
            this.getContext().newBodyInvoker().withContexts(new Object[]{EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)EnvironmentExpander.constant(Collections.singletonMap("STAGE_NAME", this.step.name)))}).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).withDisplayName(this.step.name).start();
            return false;
        }
        ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println(Messages.StageStepExecution_non_block_mode_deprecated());
        FlowNode node = (FlowNode)this.getContext().get(FlowNode.class);
        node.addAction((Action)new LabelAction(this.step.name));
        node.addAction((Action)new StageActionImpl(this.step.name));
        this.getContext().onSuccess(null);
        return true;
    }

    @Deprecated
    private static final class StageActionImpl
    extends InvisibleAction
    implements StageAction {
        private final String stageName;

        StageActionImpl(String stageName) {
            this.stageName = stageName;
        }

        public String getStageName() {
            return this.stageName;
        }
    }

    @Deprecated
    public static final class CanceledCause
    extends CauseOfInterruption {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="correct")
        private final String newerBuild;

        private CanceledCause() {
            throw new AssertionError((Object)"no longer constructed");
        }

        public Run<?, ?> getNewerBuild() {
            return Run.fromExternalizableId((String)this.newerBuild);
        }

        public String getShortDescription() {
            return "Superseded by " + this.getNewerBuild().getDisplayName();
        }
    }
}

