/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jenkinsci.plugins.pipeline.StageTagsMetadata;
import org.jenkinsci.plugins.workflow.actions.TagsAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

@Extension
public class StageStatus
extends StageTagsMetadata {
    public static final String TAG_NAME = "STAGE_STATUS";

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public List<String> getPossibleValues() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.addAll(this.getSkippedStageValues());
        vals.add(StageStatus.getFailedAndContinued());
        return vals;
    }

    public List<String> getSkippedStageValues() {
        return StageStatus.skippedStages();
    }

    @NonNull
    public static List<String> skippedStages() {
        return Arrays.asList(StageStatus.getSkippedForConditional(), StageStatus.getSkippedForFailure(), StageStatus.getSkippedForUnstable(), StageStatus.getSkippedForRestart());
    }

    public static String getFailedAndContinued() {
        return "FAILED_AND_CONTINUED";
    }

    public static String getSkippedForFailure() {
        return "SKIPPED_FOR_FAILURE";
    }

    public static String getSkippedForUnstable() {
        return "SKIPPED_FOR_UNSTABLE";
    }

    public static String getSkippedForConditional() {
        return "SKIPPED_FOR_CONDITIONAL";
    }

    public static String getSkippedForRestart() {
        return "SKIPPED_FOR_RESTART";
    }

    public static boolean isSkippedStage(@NonNull FlowNode node) {
        TagsAction tagsAction = (TagsAction)node.getPersistentAction(TagsAction.class);
        if (tagsAction != null) {
            String tagValue = tagsAction.getTagValue(TAG_NAME);
            return tagValue != null && StageStatus.skippedStages().contains(tagValue);
        }
        return false;
    }

    public static boolean isSkippedStageForReason(@NonNull FlowNode node, @NonNull String reason) {
        TagsAction tagsAction;
        if (StageStatus.skippedStages().contains(reason) && (tagsAction = (TagsAction)node.getPersistentAction(TagsAction.class)) != null) {
            String tagValue = tagsAction.getTagValue(TAG_NAME);
            return tagValue != null && tagValue.equals(reason);
        }
        return false;
    }
}

