/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class FilePathUtils {
    private static final Logger LOGGER = Logger.getLogger(FilePathUtils.class.getName());

    @CheckForNull
    public static String getNodeNameOrNull(@NonNull FilePath f) {
        return Listener.getChannelName(f.getChannel());
    }

    @NonNull
    public static String getNodeName(@NonNull FilePath f) throws IllegalStateException {
        String name = FilePathUtils.getNodeNameOrNull(f);
        if (name != null) {
            return name;
        }
        throw new IllegalStateException("no known agent for " + String.valueOf(f) + " among " + String.valueOf(Listener.getChannelNames()));
    }

    @CheckForNull
    public static FilePath find(@NonNull String node, @NonNull String path) {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            return null;
        }
        Computer c = j.getComputer(node);
        if (c == null) {
            return null;
        }
        VirtualChannel ch = c.getChannel();
        if (ch == null) {
            return null;
        }
        return new FilePath(ch, path);
    }

    private FilePathUtils() {
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final class Listener
    extends ComputerListener {
        private static final Map<VirtualChannel, String> channelNames = Collections.synchronizedMap(new WeakHashMap());

        static String getChannelName(@NonNull VirtualChannel channel) {
            Jenkins jenkins;
            String channelName = channelNames.get(channel);
            if (channelName == null && (jenkins = Jenkins.getInstanceOrNull()) != null) {
                for (Computer computer : jenkins.getComputers()) {
                    VirtualChannel computerChannel = computer.getChannel();
                    if (computerChannel == null || !computerChannel.equals(channel)) continue;
                    channelName = computer.getName();
                    Listener.addChannel(computerChannel, channelName);
                }
            }
            return channelName;
        }

        static Collection<String> getChannelNames() {
            return channelNames.values();
        }

        public void onOnline(Computer c, TaskListener l) {
            if (c instanceof Jenkins.MasterComputer) {
                Listener.addChannel(c.getChannel(), c.getName());
            }
        }

        public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) {
            Listener.addChannel((VirtualChannel)channel, c.getName());
        }

        private static void addChannel(VirtualChannel channel, String computerName) {
            if (channel == null) {
                LOGGER.log(Level.WARNING, "Invalid attempt to add a 'null' Channel instance.");
                return;
            }
            if (computerName == null) {
                LOGGER.log(Level.WARNING, "Invalid attempt to add a Channel for a 'null' Computer name.");
                return;
            }
            channelNames.put(channel, computerName);
        }
    }
}

