/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import hudson.remoting.ProxyException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.output.NullOutputStream;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

public class ErrorAction
implements PersistentAction {
    private static final Logger LOGGER = Logger.getLogger(ErrorAction.class.getName());
    @NonNull
    private final Throwable error;

    public ErrorAction(@NonNull Throwable error) {
        Throwable errorForAction = error;
        if (this.isUnserializableException(error, new HashSet<Throwable>())) {
            LOGGER.log(Level.FINE, "sanitizing unserializable error", error);
            errorForAction = new ProxyException(error);
        } else if (error != null) {
            try {
                Jenkins.XSTREAM2.toXMLUTF8((Object)error, (OutputStream)new NullOutputStream());
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, "unable to serialize to XML", x);
                errorForAction = new ProxyException(error);
            }
        }
        this.error = errorForAction;
        String id = ErrorAction.findId(error, new HashSet<Throwable>());
        if (id == null) {
            ErrorId errorId = new ErrorId();
            errorForAction.addSuppressed(errorId);
            if (error != errorForAction) {
                error.addSuppressed(errorId);
            }
        }
    }

    private boolean isUnserializableException(@CheckForNull Throwable error, Set<Throwable> visited) {
        if (error == null || !visited.add(error)) {
            return false;
        }
        if (error.getClass().getClassLoader() instanceof GroovyClassLoader) {
            return true;
        }
        if (error instanceof MissingPropertyException && ((MissingPropertyException)error).getType() != null && ((MissingPropertyException)error).getType().getClassLoader() instanceof GroovyClassLoader) {
            return true;
        }
        if (error instanceof MultipleCompilationErrorsException || error instanceof MissingMethodException) {
            return true;
        }
        if (this.isUnserializableException(error.getCause(), visited)) {
            return true;
        }
        for (Throwable t : error.getSuppressed()) {
            if (!this.isUnserializableException(t, visited)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public Throwable getError() {
        return this.error;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return this.error.getMessage();
    }

    public String getUrlName() {
        return null;
    }

    @CheckForNull
    public static FlowNode findOrigin(@NonNull Throwable error, @NonNull FlowExecution execution) {
        FlowNode candidate = null;
        for (FlowNode n : new ForkScanner().allNodes(execution)) {
            ErrorAction errorAction = n.getPersistentAction(ErrorAction.class);
            if (errorAction == null || !ErrorAction.equals(error, errorAction.getError())) continue;
            candidate = n;
        }
        return candidate;
    }

    @CheckForNull
    private static String findId(Throwable error, Set<Throwable> visited) {
        if (error == null || !visited.add(error)) {
            return null;
        }
        for (Throwable suppressed : error.getSuppressed()) {
            if (!(suppressed instanceof ErrorId)) continue;
            return ((ErrorId)suppressed).uuid;
        }
        return ErrorAction.findId(error.getCause(), visited);
    }

    @Restricted(value={Beta.class})
    public static boolean equals(Throwable t1, Throwable t2) {
        Throwable _t2;
        boolean noProxy;
        if (t1 == t2) {
            LOGGER.fine(() -> "Same object: " + String.valueOf(t1));
            return true;
        }
        boolean bl = noProxy = t1.getClass() != ProxyException.class && t2.getClass() != ProxyException.class;
        if (noProxy && t1.getClass() != t2.getClass()) {
            LOGGER.fine(() -> "Different types: " + String.valueOf(t1.getClass()) + " vs. " + String.valueOf(t2.getClass()));
            return false;
        }
        if (noProxy && !Objects.equals(t1.getMessage(), t2.getMessage())) {
            LOGGER.fine(() -> "Different messages: " + t1.getMessage() + " vs. " + t2.getMessage());
            return false;
        }
        String id1 = ErrorAction.findId(t1, new HashSet<Throwable>());
        if (id1 != null) {
            String id2 = ErrorAction.findId(t2, new HashSet<Throwable>());
            if (id1.equals(id2)) {
                LOGGER.fine(() -> "ErrorId matches: " + id1);
                return true;
            }
            LOGGER.fine(() -> "ErrorId mismatch: " + String.valueOf(t1) + " " + id1 + " vs. " + String.valueOf(t2) + " " + id2);
            return false;
        }
        Throwable _t1 = t1;
        for (_t2 = t2; _t1 != null && _t2 != null; _t1 = _t1.getCause(), _t2 = _t2.getCause()) {
            if (Arrays.equals(_t1.getStackTrace(), _t2.getStackTrace())) continue;
            LOGGER.fine(() -> "Different stack traces between " + String.valueOf(t1) + " vs. " + String.valueOf(t2));
            return false;
        }
        if (_t1 == null == (_t2 == null)) {
            LOGGER.fine(() -> "Same stack traces in " + String.valueOf(t1) + " vs. " + String.valueOf(t2));
            return true;
        }
        LOGGER.fine(() -> "Different cause depths between " + String.valueOf(t1) + " vs. " + String.valueOf(t2));
        return false;
    }

    private static class ErrorId
    extends Throwable {
        private final String uuid = UUID.randomUUID().toString();

        @Override
        public String getMessage() {
            return this.uuid;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

