/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Result;
import java.io.IOException;
import java.util.List;
import jenkins.model.CauseOfInterruption;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowActionStorage;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.GraphLookupView;
import org.jenkinsci.plugins.workflow.graph.StandardGraphLookupView;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class FlowExecution
implements FlowActionStorage,
GraphLookupView {
    protected transient GraphLookupView internalGraphLookup = null;
    @CheckForNull
    protected FlowDurabilityHint durabilityHint = null;

    protected synchronized GraphLookupView getInternalGraphLookup() {
        if (this.internalGraphLookup == null) {
            StandardGraphLookupView lookupView = new StandardGraphLookupView();
            this.internalGraphLookup = lookupView;
            this.addListener(lookupView);
        }
        return this.internalGraphLookup;
    }

    @NonNull
    public FlowDurabilityHint getDurabilityHint() {
        return this.durabilityHint != null ? this.durabilityHint : FlowDurabilityHint.MAX_SURVIVABILITY;
    }

    public abstract void start() throws IOException;

    public void onLoad(FlowExecutionOwner owner) throws IOException {
        if (Util.isOverridden(FlowExecution.class, this.getClass(), (String)"onLoad", (Class[])new Class[0])) {
            this.onLoad();
        }
    }

    @Deprecated
    public void onLoad() {
        throw new AbstractMethodError("you must implement the new overload of onLoad");
    }

    public abstract FlowExecutionOwner getOwner();

    public abstract List<FlowNode> getCurrentHeads();

    public ListenableFuture<List<StepExecution>> getCurrentExecutions(boolean innerMostOnly) {
        if (Util.isOverridden(FlowExecution.class, this.getClass(), (String)"getCurrentExecutions", (Class[])new Class[0]) && innerMostOnly) {
            return this.getCurrentExecutions();
        }
        throw new AbstractMethodError("you must implement the new overload of getCurrentExecutions");
    }

    @Deprecated
    public ListenableFuture<List<StepExecution>> getCurrentExecutions() {
        throw new AbstractMethodError("you must implement the new overload of getCurrentExecutions");
    }

    public abstract boolean isCurrentHead(FlowNode var1);

    public String getUrl() throws IOException {
        return this.getOwner().getUrlOfExecution();
    }

    public abstract void interrupt(Result var1, CauseOfInterruption ... var2) throws IOException, InterruptedException;

    public abstract void addListener(GraphListener var1);

    public void removeListener(GraphListener listener) {
    }

    public boolean isComplete() {
        List<FlowNode> heads = this.getCurrentHeads();
        return heads.size() == 1 && heads.get(0) instanceof FlowEndNode;
    }

    public boolean blocksRestart() {
        return true;
    }

    @CheckForNull
    public final Throwable getCauseOfFailure() {
        List<FlowNode> heads = this.getCurrentHeads();
        if (heads.size() != 1 || !(heads.get(0) instanceof FlowEndNode)) {
            return null;
        }
        FlowNode e = heads.get(0);
        ErrorAction error = e.getPersistentAction(ErrorAction.class);
        if (error == null) {
            return null;
        }
        return error.getError();
    }

    @CheckForNull
    public abstract FlowNode getNode(String var1) throws IOException;

    @NonNull
    public org.springframework.security.core.Authentication getAuthentication2() {
        return (org.springframework.security.core.Authentication)Util.ifOverridden(() -> this.getAuthentication().toSpring(), Authentication.class, this.getClass(), (String)"getAuthentication", (Class[])new Class[0]);
    }

    @Deprecated
    @NonNull
    public Authentication getAuthentication() {
        return (Authentication)Util.ifOverridden(() -> Authentication.fromSpring((org.springframework.security.core.Authentication)this.getAuthentication2()), org.springframework.security.core.Authentication.class, this.getClass(), (String)"getAuthentication2", (Class[])new Class[0]);
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    public boolean isActive(@NonNull FlowNode node) {
        if (!this.equals(node.getExecution())) {
            throw new IllegalArgumentException("Can't look up info for a FlowNode that doesn't belong to this execution!");
        }
        return this.getInternalGraphLookup().isActive(node);
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public BlockEndNode getEndNode(@NonNull BlockStartNode startNode) {
        if (!this.equals(startNode.getExecution())) {
            throw new IllegalArgumentException("Can't look up info for a FlowNode that doesn't belong to this execution!");
        }
        return this.getInternalGraphLookup().getEndNode(startNode);
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public BlockStartNode findEnclosingBlockStart(@NonNull FlowNode node) {
        if (!this.equals(node.getExecution())) {
            throw new IllegalArgumentException("Can't look up info for a FlowNode that doesn't belong to this execution!");
        }
        return this.getInternalGraphLookup().findEnclosingBlockStart(node);
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    @NonNull
    public List<BlockStartNode> findAllEnclosingBlockStarts(@NonNull FlowNode node) {
        if (!this.equals(node.getExecution())) {
            throw new IllegalArgumentException("Can't look up info for a FlowNode that doesn't belong to this execution!");
        }
        return this.getInternalGraphLookup().findAllEnclosingBlockStarts(node);
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    @NonNull
    public Iterable<BlockStartNode> iterateEnclosingBlocks(@NonNull FlowNode node) {
        if (!this.equals(node.getExecution())) {
            throw new IllegalArgumentException("Can't look up info for a FlowNode that doesn't belong to this execution!");
        }
        return this.getInternalGraphLookup().iterateEnclosingBlocks(node);
    }

    protected void afterStepExecutionsResumed() {
    }
}

