/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graph;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public interface GraphLookupView {
    public boolean isActive(@NonNull FlowNode var1);

    @CheckForNull
    public BlockEndNode getEndNode(@NonNull BlockStartNode var1);

    @CheckForNull
    public BlockStartNode findEnclosingBlockStart(@NonNull FlowNode var1);

    public Iterable<BlockStartNode> iterateEnclosingBlocks(@NonNull FlowNode var1);

    @NonNull
    public List<BlockStartNode> findAllEnclosingBlockStarts(@NonNull FlowNode var1);

    public static class EnclosingBlocksIterable
    implements Iterable<BlockStartNode> {
        FlowNode node;
        GraphLookupView view;

        public EnclosingBlocksIterable(@NonNull GraphLookupView view, @NonNull FlowNode node) {
            this.view = view;
            this.node = node;
        }

        @Override
        public Iterator<BlockStartNode> iterator() {
            return new EnclosingBlocksIterator(this.node);
        }

        class EnclosingBlocksIterator
        implements Iterator<BlockStartNode> {
            BlockStartNode next;

            EnclosingBlocksIterator(FlowNode start) {
                this.next = EnclosingBlocksIterable.this.view.findEnclosingBlockStart(start);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public BlockStartNode next() {
                if (this.hasNext()) {
                    BlockStartNode retVal = this.next;
                    this.next = EnclosingBlocksIterable.this.view.findEnclosingBlockStart(this.next);
                    return retVal;
                }
                throw new NoSuchElementException("No more block start nodes");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("You cannot remove FlowNodes, once written they are immutable!");
            }
        }
    }
}

