/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public final class NodeStepNamePredicate
implements Predicate<FlowNode> {
    String descriptorId;

    public NodeStepNamePredicate(@NonNull String descriptorId) {
        this.descriptorId = descriptorId;
    }

    public String getDescriptorId() {
        return this.descriptorId;
    }

    public boolean apply(@Nullable FlowNode input) {
        if (input instanceof StepNode) {
            StepDescriptor sd = ((StepNode)((Object)input)).getDescriptor();
            return sd != null && this.descriptorId.equals(sd.getId());
        }
        if (input != null && !(input instanceof FlowStartNode) && !(input instanceof FlowEndNode)) {
            try {
                Method getDescriptorMethod = ((Object)((Object)input)).getClass().getMethod("getDescriptor", null);
                StepDescriptor sd = (StepDescriptor)getDescriptorMethod.invoke((Object)input, null);
                return sd != null && this.descriptorId.equals(sd.getId());
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

