/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleAnnotationOutputStream;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.output.CountingOutputStream;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.ConsoleAnnotators;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public final class FileLogStorage
implements LogStorage {
    private static final Logger LOGGER = Logger.getLogger(FileLogStorage.class.getName());
    private static final Map<File, FileLogStorage> openStorages = Collections.synchronizedMap(new HashMap());
    private final File log;
    private final File index;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="actually it is always accessed within the monitor")
    private FileOutputStream os;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="actually it is always accessed within the monitor")
    private long osStartPosition;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="actually it is always accessed within the monitor")
    private CountingOutputStream cos;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="we only care about synchronizing writes")
    private OutputStream bos;
    private Writer indexOs;
    private String lastId;

    public static synchronized LogStorage forFile(File log) {
        return openStorages.computeIfAbsent(log, FileLogStorage::new);
    }

    private FileLogStorage(File log) {
        this.log = log;
        this.index = new File(String.valueOf(log) + "-index");
    }

    private synchronized void open() throws IOException {
        if (this.os == null) {
            this.os = new FileOutputStream(this.log, true);
            this.osStartPosition = this.log.length();
            this.cos = new CountingOutputStream((OutputStream)this.os);
            this.bos = LogStorage.wrapWithAutoFlushingBuffer((OutputStream)this.cos);
            if (this.index.isFile()) {
                try (BufferedReader r = Files.newBufferedReader(this.index.toPath(), StandardCharsets.UTF_8);){
                    String line;
                    String lastLine = null;
                    while ((line = r.readLine()) != null) {
                        lastLine = line;
                    }
                    if (lastLine != null) {
                        int space = lastLine.indexOf(32);
                        this.lastId = space == -1 ? null : lastLine.substring(space + 1);
                    }
                }
            }
            this.indexOs = new OutputStreamWriter((OutputStream)new FileOutputStream(this.index, true), StandardCharsets.UTF_8);
        }
    }

    @Override
    @NonNull
    public BuildListener overallListener() throws IOException {
        return LogStorage.wrapWithRemoteAutoFlushingListener(new IndexOutputStream(null));
    }

    @Override
    @NonNull
    public TaskListener nodeListener(@NonNull FlowNode node) throws IOException {
        return LogStorage.wrapWithRemoteAutoFlushingListener(new IndexOutputStream(node.getId()));
    }

    private void checkId(String id) throws IOException {
        assert (Thread.holdsLock(this));
        if (!Objects.equals(id, this.lastId)) {
            this.bos.flush();
            long pos = this.osStartPosition + this.cos.getByteCount();
            if (id == null) {
                this.indexOs.write(pos + "\n");
            } else {
                this.indexOs.write(pos + " " + id + "\n");
            }
            this.indexOs.flush();
            this.lastId = id;
        }
    }

    private void maybeFlush() {
        if (this.bos != null) {
            try {
                this.bos.flush();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "failed to flush " + String.valueOf(this.log), x);
            }
        }
    }

    @Override
    @NonNull
    public AnnotatedLargeText<FlowExecutionOwner.Executable> overallLog(final @NonNull FlowExecutionOwner.Executable build, boolean complete) {
        this.maybeFlush();
        return new AnnotatedLargeText<FlowExecutionOwner.Executable>(this.log, StandardCharsets.UTF_8, complete, build){

            public long writeHtmlTo(final long start, final Writer w) throws IOException {
                try (final BufferedReader indexBR = FileLogStorage.this.index.isFile() ? Files.newBufferedReader(FileLogStorage.this.index.toPath(), StandardCharsets.UTF_8) : new BufferedReader((Reader)new NullReader(0L));){
                    ConsoleAnnotationOutputStream caos = new ConsoleAnnotationOutputStream(w, ConsoleAnnotators.createAnnotator(build), (Object)build, StandardCharsets.UTF_8);
                    long r = this.writeRawLogTo(start, new FilterOutputStream((OutputStream)caos){
                        long lastTransition;
                        boolean eof;
                        String lastId;
                        long pos;
                        boolean hadLastId;
                        {
                            super(out);
                            this.lastTransition = -1L;
                            this.pos = start;
                        }

                        @Override
                        public void write(int b) throws IOException {
                            while (this.lastTransition < this.pos && !this.eof) {
                                String line = indexBR.readLine();
                                if (line == null) {
                                    this.eof = true;
                                    break;
                                }
                                int space = line.indexOf(32);
                                try {
                                    this.lastTransition = Long.parseLong(space == -1 ? line : line.substring(0, space));
                                }
                                catch (NumberFormatException x) {
                                    LOGGER.warning("Ignoring corrupt index file " + String.valueOf(FileLogStorage.this.index));
                                }
                                this.lastId = space == -1 ? null : line.substring(space + 1);
                            }
                            if (this.pos == this.lastTransition) {
                                if (this.hadLastId) {
                                    w.write(LogStorage.endStep());
                                }
                                boolean bl = this.hadLastId = this.lastId != null;
                                if (this.lastId != null) {
                                    w.write(LogStorage.startStep(this.lastId));
                                }
                            }
                            super.write(b);
                            ++this.pos;
                        }

                        @Override
                        public void flush() throws IOException {
                            if (this.lastId != null) {
                                w.write(LogStorage.endStep());
                            }
                            super.flush();
                        }
                    });
                    ConsoleAnnotators.setAnnotator(caos.getConsoleAnnotator());
                    long l = r;
                    return l;
                }
            }
        };
    }

    /*
     * Exception decompiling
     */
    @Override
    @NonNull
    public AnnotatedLargeText<FlowNode> stepLog(@NonNull FlowNode node, boolean complete) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Deprecated
    @NonNull
    public File getLogFile(@NonNull FlowExecutionOwner.Executable build, boolean complete) {
        return this.log;
    }

    private final class IndexOutputStream
    extends OutputStream {
        private final String id;

        IndexOutputStream(String id) throws IOException {
            this.id = id;
            FileLogStorage.this.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            FileLogStorage fileLogStorage = FileLogStorage.this;
            synchronized (fileLogStorage) {
                FileLogStorage.this.checkId(this.id);
                FileLogStorage.this.bos.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(@NonNull byte[] b) throws IOException {
            FileLogStorage fileLogStorage = FileLogStorage.this;
            synchronized (fileLogStorage) {
                FileLogStorage.this.checkId(this.id);
                FileLogStorage.this.bos.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(@NonNull byte[] b, int off, int len) throws IOException {
            FileLogStorage fileLogStorage = FileLogStorage.this;
            synchronized (fileLogStorage) {
                FileLogStorage.this.checkId(this.id);
                FileLogStorage.this.bos.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            FileLogStorage.this.bos.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.id == null) {
                openStorages.remove(FileLogStorage.this.log);
                try {
                    FileLogStorage.this.bos.close();
                }
                finally {
                    FileLogStorage.this.indexOs.close();
                }
            }
        }
    }
}

