/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps.durable_task;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.Map;
import org.jenkinsci.plugins.durabletask.DurableTask;
import org.jenkinsci.plugins.durabletask.WindowsBatchScript;
import org.jenkinsci.plugins.workflow.steps.durable_task.DurableTaskStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class BatchScriptStep
extends DurableTaskStep {
    private final String script;

    @DataBoundConstructor
    public BatchScriptStep(String script) {
        if (script == null) {
            throw new IllegalArgumentException();
        }
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    protected DurableTask task() {
        return new WindowsBatchScript(this.script);
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskStep.DurableTaskStepDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Windows Batch Script";
        }

        public String getFunctionName() {
            return "bat";
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Object script = namedArgs.get("script");
            return script instanceof String ? (String)script : null;
        }
    }
}

