/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Main;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.model.Queue;
import hudson.model.ResourceList;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueListener;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.model.queue.SubTask;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.RequestAbortedException;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.OfflineCause;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.model.NodeListener;
import jenkins.model.queue.AsynchronousExecution;
import jenkins.security.QueueItemAuthenticator;
import jenkins.security.QueueItemAuthenticatorProvider;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.durabletask.executors.ContinuableExecutable;
import org.jenkinsci.plugins.durabletask.executors.ContinuedTask;
import org.jenkinsci.plugins.durabletask.executors.OnceRetentionStrategy;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.QueueItemAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.durable_task.DurableTaskStep;
import org.jenkinsci.plugins.workflow.steps.durable_task.Messages;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.jenkinsci.plugins.workflow.support.concurrent.Timeout;
import org.jenkinsci.plugins.workflow.support.steps.AgentErrorCondition;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepDynamicContext;
import org.jenkinsci.plugins.workflow.support.steps.FilePathDynamicContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.access.AccessDeniedException;

public class ExecutorStepExecution
extends AbstractStepExecutionImpl {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="deliberately mutable")
    public static long TIMEOUT_WAITING_FOR_NODE_MILLIS = SystemProperties.getLong((String)"org.jenkinsci.plugins.workflow.support.pickles.ExecutorPickle.timeoutForNodeMillis", (Long)(Main.isUnitTest ? TimeUnit.SECONDS.toMillis(15L) : TimeUnit.MINUTES.toMillis(5L)));
    private final ExecutorStep step;
    private ExecutorStepDynamicContext state;
    @CheckForNull
    private BodyExecution body;
    private static final String COOKIE_VAR = "JENKINS_NODE_COOKIE";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ExecutorStepExecution.class.getName());

    ExecutorStepExecution(StepContext context, ExecutorStep step) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        PlaceholderTask task = new PlaceholderTask(this.getContext(), this.step.getLabel());
        Queue.WaitingItem waitingItem = Queue.getInstance().schedule2((Queue.Task)task, 0, new Action[0]).getCreateItem();
        if (waitingItem == null) {
            throw new IllegalStateException("failed to schedule task");
        }
        ((FlowNode)this.getContext().get(FlowNode.class)).addAction((Action)new QueueItemActionImpl(waitingItem.getId()));
        Timer.get().schedule(() -> {
            Queue.Item item = Queue.getInstance().getItem((Queue.Task)task);
            if (item != null) {
                TaskListener listener;
                try {
                    listener = (TaskListener)this.getContext().get(TaskListener.class);
                }
                catch (Exception x) {
                    LOGGER.log(Level.FINE, "could not print message to build about " + item + "; perhaps it is already completed", x);
                    return;
                }
                listener.getLogger().println("Still waiting to schedule task");
                CauseOfBlockage cob = item.getCauseOfBlockage();
                if (cob != null) {
                    cob.print(listener);
                }
            }
        }, 15L, TimeUnit.SECONDS);
        return false;
    }

    public void stop(@NonNull Throwable cause) throws Exception {
        Jenkins j;
        Queue.Item[] items;
        try (ACLContext as = ACL.as((Authentication)ACL.SYSTEM);){
            items = Queue.getInstance().getItems();
        }
        LOGGER.log(Level.FINE, cause, () -> "stopping one of " + Arrays.asList(items));
        StepContext context = this.getContext();
        for (Queue.Item item : items) {
            if (item.task instanceof PlaceholderTask) {
                PlaceholderTask task = (PlaceholderTask)item.task;
                if (task.context.equals((Object)context)) {
                    RunningTasks.run(context, t -> {
                        t.stopping = true;
                    });
                    if (Queue.getInstance().cancel(item)) {
                        LOGGER.fine(() -> "canceled " + item);
                        break;
                    }
                    LOGGER.warning(() -> "failed to cancel " + item + " in response to " + cause);
                    break;
                }
                LOGGER.log(Level.FINE, "no match on {0} with {1} vs. {2}", new Object[]{item, task.context, context});
                continue;
            }
            LOGGER.log(Level.FINE, "no match on {0}", item);
        }
        if ((j = Jenkins.getInstanceOrNull()) != null) {
            block6: for (Computer c : j.getComputers()) {
                for (hudson.model.Executor e : c.getExecutors()) {
                    Queue.Executable exec = e.getCurrentExecutable();
                    if (exec instanceof PlaceholderTask.PlaceholderExecutable) {
                        StepContext actualContext = ((PlaceholderTask.PlaceholderExecutable)exec).getParent().context;
                        if (actualContext.equals((Object)context)) {
                            PlaceholderTask.finish(context, ((PlaceholderTask.PlaceholderExecutable)exec).getParent().cookie);
                            RunningTasks.remove(context);
                            LOGGER.log(Level.FINE, "canceling {0}", exec);
                            break block6;
                        }
                        LOGGER.log(Level.FINE, "no match on {0} with {1} vs. {2}", new Object[]{exec, actualContext, context});
                        continue;
                    }
                    LOGGER.log(Level.FINE, "no match on {0}", exec);
                }
            }
        }
        super.stop(cause);
    }

    public void onResume() {
        try {
            if (this.state == null) {
                FlowNode flowNode = (FlowNode)this.getContext().get(FlowNode.class);
                LOGGER.fine(() -> "node block " + this.getContext() + " not yet scheduled, checking for an existing queue item");
                if (flowNode == null) {
                    LOGGER.fine(() -> "No FlowNode found for node block " + this.getContext() + "; can't recover");
                } else {
                    QueueItemActionImpl action = (QueueItemActionImpl)flowNode.getAction(QueueItemActionImpl.class);
                    if (action == null) {
                        LOGGER.fine(() -> "No QueueItemAction found for node block " + this.getContext() + "; can't recover");
                    } else {
                        LOGGER.fine(() -> "QueueItemAction with id=" + action.id + " found for node block " + this.getContext());
                        Queue.Item queueItem = action.itemInQueue();
                        if (queueItem == null) {
                            LOGGER.fine(() -> "Could not find queue item " + action.id + ", rescheduling it");
                            flowNode.removeActions(QueueItemActionImpl.class);
                            this.start();
                        } else {
                            LOGGER.fine(() -> "Found Queue.Item " + queueItem + " for node block " + this.getContext() + "; should be fine");
                        }
                    }
                }
                return;
            }
            this.state.resume(this.getContext());
        }
        catch (Exception x) {
            try {
                this.stop(x);
            }
            catch (Exception x2) {
                x.addSuppressed(x2);
                this.getContext().onFailure((Throwable)x);
            }
        }
    }

    public String getStatus() {
        for (Queue.Item item : Queue.getInstance().getItems()) {
            if (!(item.task instanceof PlaceholderTask) || !((PlaceholderTask)item.task).context.equals((Object)this.getContext())) continue;
            return "waiting for " + item.task.getFullDisplayName() + " to be scheduled; blocked: " + item.getWhy();
        }
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null) {
            for (Computer c : j.getComputers()) {
                for (hudson.model.Executor e : c.getExecutors()) {
                    Queue.Executable exec = e.getCurrentExecutable();
                    if (!(exec instanceof PlaceholderTask.PlaceholderExecutable) || !((PlaceholderTask.PlaceholderExecutable)exec).getParent().context.equals((Object)this.getContext())) continue;
                    return "running on " + c.getName();
                }
            }
        }
        return "node block appears to be neither running nor scheduled";
    }

    @ExportedBean
    public static final class PlaceholderTask
    implements ContinuedTask,
    Serializable,
    AccessControlled {
        private final StepContext context;
        private String label;
        private boolean labelIsSelfLabel;
        private final String runId;
        private String cookie;
        @CheckForNull
        private final String auth;
        private transient int lastCheckedHashCode;
        private transient String lastEnclosingLabel;
        private static final long serialVersionUID = 1098885580375315588L;

        PlaceholderTask(StepContext context, String label) throws IOException, InterruptedException {
            this.context = context;
            this.label = label;
            this.runId = ((Run)context.get(Run.class)).getExternalizableId();
            Authentication runningAuth = Jenkins.getAuthentication();
            this.auth = runningAuth.equals(ACL.SYSTEM) ? null : runningAuth.getName();
            RunningTasks.add(context);
            LOGGER.log(Level.FINE, "scheduling {0}", this);
        }

        private Object readResolve() {
            RunningTasks.add(this.context);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, null, new Exception("deserializing previously scheduled " + this));
            }
            return this;
        }

        private void withExecution(final Consumer<ExecutorStepExecution> executionCallback) {
            try {
                Futures.addCallback((ListenableFuture)((FlowExecution)this.context.get(FlowExecution.class)).getCurrentExecutions(false), (FutureCallback)new FutureCallback<List<StepExecution>>(){

                    public void onSuccess(List<StepExecution> result) {
                        for (StepExecution execution : result) {
                            if (!(execution instanceof ExecutorStepExecution) || !execution.getContext().equals((Object)context)) continue;
                            executionCallback.accept((ExecutorStepExecution)execution);
                        }
                    }

                    public void onFailure(Throwable x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
            catch (IOException | InterruptedException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }

        @CheckForNull
        public FlowNode getNode() throws IOException, InterruptedException {
            return (FlowNode)this.context.get(FlowNode.class);
        }

        public Queue.Executable createExecutable() throws IOException {
            return new PlaceholderExecutable();
        }

        @Restricted(value={NoExternalUse.class})
        public boolean hasStarted() {
            return this.cookie != null;
        }

        public Label getAssignedLabel() {
            if (this.label == null) {
                return null;
            }
            if (this.label.isEmpty()) {
                Jenkins j = Jenkins.getInstanceOrNull();
                if (j == null) {
                    return null;
                }
                return j.getSelfLabel();
            }
            return Label.get((String)this.label);
        }

        public Node getLastBuiltOn() {
            if (this.label == null) {
                return null;
            }
            Jenkins j = Jenkins.getInstanceOrNull();
            if (j == null) {
                return null;
            }
            return j.getNode(this.label);
        }

        @Deprecated
        public boolean isBuildBlocked() {
            return false;
        }

        @Deprecated
        public String getWhyBlocked() {
            return null;
        }

        public CauseOfBlockage getCauseOfBlockage() {
            Run<?, ?> run;
            boolean stopping = RunningTasks.get(this.context, t -> t.stopping, () -> false);
            if (FlowExecutionList.get().isResumptionComplete() && (run = this.runForDisplay()) != null && !run.isLogUpdated()) {
                if (stopping) {
                    LOGGER.warning(() -> "Refusing to build " + this + " and going to cancel it, even though it was supposedly stopped already, because associated build is complete");
                } else {
                    RunningTasks.run(this.context, t -> {
                        t.stopping = true;
                    });
                }
                Timer.get().execute(() -> {
                    if (Queue.getInstance().cancel((Queue.Task)this)) {
                        LOGGER.warning(() -> "Refusing to build " + this + " and cancelling it because associated build is complete");
                    } else {
                        LOGGER.warning(() -> "Refusing to build " + this + " because associated build is complete, but failed to cancel it");
                    }
                });
            }
            if (stopping) {
                return new CauseOfBlockage(){

                    public String getShortDescription() {
                        return "Stopping " + this.getDisplayName();
                    }
                };
            }
            return null;
        }

        public boolean isConcurrentBuild() {
            return false;
        }

        public Collection<? extends SubTask> getSubTasks() {
            return Collections.singleton(this);
        }

        @NonNull
        public Queue.Task getOwnerTask() {
            Run<?, ?> r;
            Jenkins j = Jenkins.getInstanceOrNull();
            if (j != null && this.runId != null) {
                try (ACLContext context = ACL.as((Authentication)ACL.SYSTEM);){
                    Job job = (Job)j.getItemByFullName(this.runId.substring(0, this.runId.lastIndexOf(35)), Job.class);
                    if (job instanceof Queue.Task) {
                        Queue.Task task = (Queue.Task)job;
                        return task;
                    }
                }
            }
            if ((r = this.runForDisplay()) != null && r.getParent() instanceof Queue.Task) {
                return (Queue.Task)r.getParent();
            }
            return this;
        }

        public Object getSameNodeConstraint() {
            return null;
        }

        @NonNull
        public ACL getACL() {
            try {
                Run<?, ?> r = this.runForDisplay();
                if (r != null) {
                    return r.getACL();
                }
                Job job = (Job)Jenkins.get().getItemByFullName(this.runId.substring(0, this.runId.lastIndexOf(35)), Job.class);
                if (job != null) {
                    return job.getACL();
                }
            }
            catch (AccessDeniedException r) {
            }
            catch (RuntimeException x) {
                LOGGER.log(Level.WARNING, "checking permissions on " + this, x);
            }
            return Jenkins.get().getACL();
        }

        public void checkAbortPermission() {
            this.checkPermission(Item.CANCEL);
        }

        public boolean hasAbortPermission() {
            return this.hasPermission(Item.CANCEL);
        }

        @Deprecated
        @CheckForNull
        public Run<?, ?> run() {
            try {
                if (!this.context.isReady()) {
                    return null;
                }
                return (Run)this.context.get(Run.class);
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, "broken " + this.context, x);
                PlaceholderTask.finish(this.context, this.cookie);
                RunningTasks.remove(this.context);
                return null;
            }
        }

        @Deprecated
        @CheckForNull
        public Run<?, ?> runForDisplay() {
            Run<?, ?> r = this.run();
            if (r == null && this.runId != null) {
                Run run;
                block9: {
                    ACLContext ctx = ACL.as2((org.springframework.security.core.Authentication)ACL.SYSTEM2);
                    try {
                        run = Run.fromExternalizableId((String)this.runId);
                        if (ctx == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ctx != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (AccessDeniedException x) {
                            return null;
                        }
                    }
                    ctx.close();
                }
                return run;
            }
            return r;
        }

        @CheckForNull
        public Queue.Executable getOwnerExecutable() {
            Run<?, ?> r = this.runForDisplay();
            return r instanceof Queue.Executable ? (Queue.Executable)r : null;
        }

        @Exported
        public String getUrl() {
            Run<?, ?> r = this.runForDisplay();
            return r != null ? r.getUrl() : "";
        }

        public String getDisplayName() {
            Run<?, ?> r = this.runForDisplay();
            if (r != null) {
                String runDisplayName = r.getFullDisplayName();
                String enclosingLabel = this.getEnclosingLabel();
                if (enclosingLabel != null) {
                    return Messages.ExecutorStepExecution_PlaceholderTask_displayName_label(runDisplayName, enclosingLabel);
                }
                return Messages.ExecutorStepExecution_PlaceholderTask_displayName(runDisplayName);
            }
            return Messages.ExecutorStepExecution_PlaceholderTask_displayName(this.runId);
        }

        @Exported
        public String getName() {
            return this.getDisplayName();
        }

        @Exported
        public String getFullDisplayName() {
            return this.getDisplayName();
        }

        static String findLabelName(FlowNode flowNode) {
            LabelAction la = (LabelAction)flowNode.getPersistentAction(LabelAction.class);
            if (la != null) {
                return la.getDisplayName();
            }
            return null;
        }

        private String concatenateAllEnclosingLabels(StringBuilder labelName) {
            if (!this.context.isReady()) {
                return labelName.toString();
            }
            FlowNode executorStepNode = null;
            try (Timeout t = Timeout.limit((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);){
                executorStepNode = (FlowNode)this.context.get(FlowNode.class);
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, null, x);
            }
            if (executorStepNode != null) {
                for (FlowNode node : executorStepNode.getEnclosingBlocks()) {
                    String currentLabelName = PlaceholderTask.findLabelName(node);
                    if (currentLabelName == null) continue;
                    labelName.append("#");
                    labelName.append(currentLabelName);
                }
            }
            return labelName.toString();
        }

        public String getAffinityKey() {
            StringBuilder ownerTaskName = new StringBuilder(this.getOwnerTask().getName());
            return this.concatenateAllEnclosingLabels(ownerTaskName);
        }

        @Restricted(value={Beta.class})
        @CheckForNull
        public String getEnclosingLabel() {
            FlowNode executorStepNode;
            if (!this.context.isReady()) {
                return null;
            }
            try (Timeout t = Timeout.limit((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);){
                executorStepNode = (FlowNode)this.context.get(FlowNode.class);
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, null, x);
                return null;
            }
            if (executorStepNode == null) {
                return null;
            }
            List heads = executorStepNode.getExecution().getCurrentHeads();
            int headsHash = heads.hashCode();
            if (headsHash == this.lastCheckedHashCode) {
                return this.lastEnclosingLabel;
            }
            this.lastCheckedHashCode = headsHash;
            this.lastEnclosingLabel = this.computeEnclosingLabel(executorStepNode, heads);
            return this.lastEnclosingLabel;
        }

        private String computeEnclosingLabel(FlowNode executorStepNode, List<FlowNode> heads) {
            block0: for (FlowNode runningNode : heads) {
                boolean match = false;
                String enclosingLabel = null;
                int count = 0;
                for (FlowNode n : runningNode.iterateEnclosingBlocks()) {
                    if (enclosingLabel == null) {
                        ThreadNameAction tna = (ThreadNameAction)n.getPersistentAction(ThreadNameAction.class);
                        if (tna != null) {
                            enclosingLabel = tna.getThreadName();
                        } else {
                            LabelAction a = (LabelAction)n.getPersistentAction(LabelAction.class);
                            if (a != null) {
                                enclosingLabel = a.getDisplayName();
                            }
                        }
                        if (match && enclosingLabel != null) {
                            return enclosingLabel;
                        }
                    }
                    if (n.equals((Object)executorStepNode)) {
                        if (enclosingLabel != null) {
                            return enclosingLabel;
                        }
                        match = true;
                    }
                    if (count++ <= 100) continue;
                    continue block0;
                }
            }
            return null;
        }

        public long getEstimatedDuration() {
            Run<?, ?> r = this.runForDisplay();
            return r != null ? r.getEstimatedDuration() : -1L;
        }

        public ResourceList getResourceList() {
            return new ResourceList();
        }

        @NonNull
        public Authentication getDefaultAuthentication() {
            return ACL.SYSTEM;
        }

        @NonNull
        public Authentication getDefaultAuthentication(Queue.Item item) {
            return this.getDefaultAuthentication();
        }

        public boolean isContinued() {
            return this.cookie != null;
        }

        public String toString() {
            return "ExecutorStepExecution.PlaceholderTask{label=" + this.label + ",context=" + this.context + "}";
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + Objects.hashCode(this.context);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PlaceholderTask other = (PlaceholderTask)obj;
            return this.context.equals((Object)other.context);
        }

        private static void finish(StepContext context, @CheckForNull String cookie) {
            RunningTask runningTask = RunningTasks.get(context);
            if (runningTask == null) {
                LOGGER.fine(() -> "no known running task for " + context);
                return;
            }
            AsynchronousExecution execution = runningTask.execution;
            if (execution == null) {
                LOGGER.fine(() -> "no AsynchronousExecution associated with " + context + " (JENKINS-30759 maybe finished before asynch execution was even scheduled?)");
                return;
            }
            assert (runningTask.launcher != null);
            runningTask.execution = null;
            Timer.get().submit(() -> execution.completed(null));
            if (cookie == null) {
                LOGGER.fine(() -> "no cookie to kill from " + context);
                return;
            }
            Computer.threadPoolForRemoting.submit(() -> {
                try {
                    runningTask.launcher.kill(Collections.singletonMap(ExecutorStepExecution.COOKIE_VAR, cookie));
                }
                catch (ChannelClosedException channelClosedException) {
                }
                catch (RequestAbortedException requestAbortedException) {
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "failed to shut down " + cookie + " from " + context, x);
                }
            });
        }

        @ExportedBean
        @Restricted(value={NoExternalUse.class})
        public final class PlaceholderExecutable
        implements ContinuableExecutable,
        AccessControlled {
            public void run() {
                Run r;
                Launcher launcher;
                TaskListener listener = null;
                Computer computer = null;
                try {
                    hudson.model.Executor exec = hudson.model.Executor.currentExecutor();
                    if (exec == null) {
                        throw new IllegalStateException("running task without associated executor thread");
                    }
                    computer = exec.getOwner();
                    Node node = computer.getNode();
                    if (node == null) {
                        throw new IllegalStateException("running computer lacks a node");
                    }
                    listener = (TaskListener)PlaceholderTask.this.context.get(TaskListener.class);
                    launcher = node.createLauncher(listener);
                    r = (Run)PlaceholderTask.this.context.get(Run.class);
                    if (PlaceholderTask.this.cookie == null) {
                        PlaceholderTask.this.cookie = UUID.randomUUID().toString();
                        PlaceholderTask.this.label = computer.getName();
                        PlaceholderTask.this.labelIsSelfLabel = true;
                        EnvVars env = computer.getEnvironment();
                        env.overrideExpandingAll((Map)computer.buildEnvironment(listener));
                        env.put(ExecutorStepExecution.COOKIE_VAR, PlaceholderTask.this.cookie);
                        if (exec.getOwner() instanceof Jenkins.MasterComputer) {
                            env.put("NODE_NAME", node.getSelfLabel().getName());
                        } else {
                            env.put("NODE_NAME", PlaceholderTask.this.label);
                        }
                        env.put("EXECUTOR_NUMBER", String.valueOf(exec.getNumber()));
                        env.put("NODE_LABELS", node.getAssignedLabels().stream().map(Object::toString).collect(Collectors.joining(" ")));
                        Job j = r.getParent();
                        if (!(j instanceof TopLevelItem)) {
                            throw new Exception(j + " must be a top-level job");
                        }
                        FilePath p = node.getWorkspaceFor((TopLevelItem)j);
                        if (p == null) {
                            throw new IllegalStateException(node + " is offline");
                        }
                        WorkspaceList.Lease lease = computer.getWorkspaceList().allocate(p);
                        FilePath workspace = lease.path;
                        env.put("WORKSPACE", workspace.getRemote());
                        FilePath tempDir = WorkspaceList.tempDir((FilePath)workspace);
                        if (tempDir != null) {
                            env.put("WORKSPACE_TMP", tempDir.getRemote());
                        }
                        FlowNode flowNode = (FlowNode)PlaceholderTask.this.context.get(FlowNode.class);
                        flowNode.addAction((Action)new WorkspaceActionImpl(workspace, flowNode));
                        listener.getLogger().println("Running on " + ModelHyperlinkNote.encodeTo((Node)node) + " in " + workspace);
                        ExecutorStepDynamicContext state = new ExecutorStepDynamicContext(PlaceholderTask.this, lease, exec, FilePathDynamicContext.depthOf(flowNode));
                        PlaceholderTask.this.withExecution(execution -> {
                            execution.state = state;
                            execution.body = PlaceholderTask.this.context.newBodyInvoker().withContexts(new Object[]{env, state}).withCallback((BodyExecutionCallback)new Callback(PlaceholderTask.this.cookie, (ExecutorStepExecution)((Object)execution))).start();
                            LOGGER.fine(() -> "started " + PlaceholderTask.this.context);
                            PlaceholderTask.this.context.saveState();
                        });
                    } else {
                        LOGGER.fine(() -> "resuming " + PlaceholderTask.this.context);
                    }
                }
                catch (Exception x) {
                    if (computer != null) {
                        OfflineCause oc;
                        for (Computer.TerminationRequest tr : computer.getTerminatedBy()) {
                            x.addSuppressed((Throwable)tr);
                        }
                        if (listener != null && (oc = computer.getOfflineCause()) != null) {
                            listener.getLogger().println(computer.getDisplayName() + " was marked offline: " + oc);
                        }
                    }
                    PlaceholderTask.this.context.onFailure((Throwable)x);
                    return;
                }
                final TaskListener _listener = listener;
                RunningTasks.run(PlaceholderTask.this.context, runningTask -> {
                    LOGGER.fine(() -> "waiting on " + PlaceholderTask.this.context);
                    assert (runningTask.execution == null);
                    assert (runningTask.launcher == null);
                    runningTask.launcher = launcher;
                    runningTask.execution = new AsynchronousExecution(){

                        public void interrupt(boolean forShutdown) {
                            if (forShutdown) {
                                return;
                            }
                            LOGGER.fine(() -> "interrupted " + PlaceholderTask.this.context);
                            Timer.get().submit(() -> {
                                hudson.model.Executor thisExecutor = this.getExecutor();
                                AtomicReference<Boolean> cancelledBodyExecution = new AtomicReference<Boolean>(false);
                                PlaceholderTask.this.withExecution(execution -> {
                                    BodyExecution body = execution.body;
                                    if (body != null) {
                                        body.cancel(thisExecutor != null ? thisExecutor.getCausesOfInterruption().toArray(new CauseOfInterruption[0]) : new CauseOfInterruption[]{});
                                        cancelledBodyExecution.set(true);
                                    }
                                });
                                if (!cancelledBodyExecution.get().booleanValue()) {
                                    if (thisExecutor != null) {
                                        thisExecutor.recordCauseOfInterruption(r, _listener);
                                    }
                                    this.completed(null);
                                }
                            });
                        }

                        public boolean blocksRestart() {
                            return false;
                        }

                        public boolean displayCell() {
                            return true;
                        }
                    };
                    throw runningTask.execution;
                });
            }

            @NonNull
            public PlaceholderTask getParent() {
                return PlaceholderTask.this;
            }

            public Queue.Executable getParentExecutable() {
                return PlaceholderTask.this.getOwnerExecutable();
            }

            @Exported
            public Integer getNumber() {
                Run<?, ?> r = this.getParent().runForDisplay();
                return r != null ? Integer.valueOf(r.getNumber()) : null;
            }

            @Exported
            public String getFullDisplayName() {
                return this.getParent().getFullDisplayName();
            }

            @Exported
            public String getDisplayName() {
                return this.getParent().getDisplayName();
            }

            @Exported
            public long getEstimatedDuration() {
                return this.getParent().getEstimatedDuration();
            }

            @Exported
            public Long getTimestamp() {
                Run<?, ?> r = this.getParent().runForDisplay();
                return r != null ? Long.valueOf(r.getStartTimeInMillis()) : null;
            }

            public boolean willContinue() {
                return RunningTasks.get(PlaceholderTask.this.context, t -> t.execution != null, () -> false);
            }

            @Restricted(value={DoNotUse.class})
            @CheckForNull
            public hudson.model.Executor getExecutor() {
                return hudson.model.Executor.of((Queue.Executable)this);
            }

            @Restricted(value={NoExternalUse.class})
            public String getUrl() {
                return PlaceholderTask.this.getUrl();
            }

            @Exported(name="url")
            public String getAbsoluteUrl() {
                Run<?, ?> r = PlaceholderTask.this.runForDisplay();
                if (r == null) {
                    return "";
                }
                Jenkins j = Jenkins.getInstanceOrNull();
                Object base = "";
                if (j != null) {
                    base = Util.removeTrailingSlash((String)j.getRootUrl()) + "/";
                }
                return (String)base + r.getUrl();
            }

            public String toString() {
                return "PlaceholderExecutable:" + PlaceholderTask.this;
            }

            @NonNull
            public ACL getACL() {
                return this.getParent().getACL();
            }

            public void checkPermission(@NonNull Permission permission) throws AccessDeniedException {
                this.getACL().checkPermission(permission);
            }

            public boolean hasPermission(@NonNull Permission permission) {
                return this.getACL().hasPermission(permission);
            }
        }

        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="lease is pickled")
        private static final class Callback
        extends BodyExecutionCallback.TailCall {
            private static final long serialVersionUID = -1357584128994454363L;
            private final String cookie;
            @Deprecated
            private WorkspaceList.Lease lease;
            private final ExecutorStepExecution execution;

            Callback(String cookie, ExecutorStepExecution execution) {
                this.cookie = cookie;
                this.execution = execution;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finished(StepContext bodyContext) throws Exception {
                if (this.execution == null) {
                    this.lease.release();
                    this.lease = null;
                    return;
                }
                LOGGER.log(Level.FINE, "finished {0}", this.execution.getContext());
                try {
                    WorkspaceList.Lease _lease = ((ExecutorStepDynamicContext.WorkspaceListLeaseTranslator)((Object)ExtensionList.lookupSingleton(ExecutorStepDynamicContext.WorkspaceListLeaseTranslator.class))).get(this.execution.state);
                    if (_lease != null) {
                        _lease.release();
                    }
                }
                finally {
                    PlaceholderTask.finish(this.execution.getContext(), this.cookie);
                }
                this.execution.body = null;
                RunningTask t = RunningTasks.get(this.execution.getContext());
                if (t != null) {
                    boolean _stopping = t.stopping;
                    t.stopping = true;
                    try {
                        if (Queue.getInstance().cancel((Queue.Task)this.execution.state.task)) {
                            LOGGER.fine(() -> "cancelled leftover task from " + this.execution.getContext());
                        }
                        LOGGER.fine(() -> "was unable to cancel any leftover task from " + this.execution.getContext());
                    }
                    finally {
                        t.stopping = _stopping;
                    }
                } else {
                    LOGGER.fine(() -> "no entry for " + this.execution.getContext());
                }
                this.execution.state = null;
                bodyContext.saveState();
                RunningTasks.remove(this.execution.getContext());
            }
        }

        @Restricted(value={NoExternalUse.class})
        @Extension(ordinal=959.0)
        public static class AuthenticationFromBuild
        extends QueueItemAuthenticatorProvider {
            @NonNull
            public List<QueueItemAuthenticator> getAuthenticators() {
                return Collections.singletonList(new QueueItemAuthenticator(){

                    public Authentication authenticate(Queue.Task task) {
                        if (task instanceof PlaceholderTask) {
                            String auth = ((PlaceholderTask)task).auth;
                            LOGGER.finer(() -> "authenticating " + task);
                            if (Jenkins.ANONYMOUS.getName().equals(auth)) {
                                return Jenkins.ANONYMOUS;
                            }
                            if (auth != null) {
                                User user = User.getById((String)auth, (boolean)false);
                                return user != null ? user.impersonate() : Jenkins.ANONYMOUS;
                            }
                        }
                        return null;
                    }
                });
            }
        }

        @Restricted(value={NoExternalUse.class})
        @Extension
        public static final class EnforceSelfLabel
        extends QueueTaskDispatcher {
            public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
                if (item.task instanceof PlaceholderTask) {
                    String nodeName;
                    final PlaceholderTask t = (PlaceholderTask)item.task;
                    if (t.labelIsSelfLabel && !(nodeName = node.getNodeName()).equals(t.label)) {
                        LOGGER.fine(() -> "Refusing to let " + item + " be run on " + node + " despite label match");
                        return new CauseOfBlockage(){

                            public String getShortDescription() {
                                return "Must run on " + t.label + " not " + nodeName;
                            }
                        };
                    }
                }
                return null;
            }
        }
    }

    private static final class QueueItemActionImpl
    extends QueueItemAction {
        private long id;

        QueueItemActionImpl(long id) {
            this.id = id;
        }

        @CheckForNull
        public Queue.Item itemInQueue() {
            return Queue.getInstance().getItem(this.id);
        }
    }

    @Extension
    public static class RunningTasks {
        private final Map<StepContext, RunningTask> runningTasks = new HashMap<StepContext, RunningTask>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void add(StepContext context) {
            RunningTasks holder;
            RunningTasks runningTasks = holder = (RunningTasks)ExtensionList.lookupSingleton(RunningTasks.class);
            synchronized (runningTasks) {
                holder.runningTasks.putIfAbsent(context, new RunningTask());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        private static RunningTask find(StepContext context) {
            RunningTasks holder;
            RunningTasks runningTasks = holder = (RunningTasks)ExtensionList.lookupSingleton(RunningTasks.class);
            synchronized (runningTasks) {
                return holder.runningTasks.get(context);
            }
        }

        static <T> T get(StepContext context, Function<RunningTask, T> fn, Supplier<T> fallback) {
            RunningTask t = RunningTasks.find(context);
            if (t != null) {
                return fn.apply(t);
            }
            LOGGER.fine(() -> "no RunningTask associated with " + context);
            return fallback.get();
        }

        @CheckForNull
        static RunningTask get(StepContext context) {
            return RunningTasks.get(context, t -> t, () -> null);
        }

        static void run(StepContext context, Consumer<RunningTask> fn) {
            RunningTask t = RunningTasks.find(context);
            if (t != null) {
                fn.accept(t);
            } else {
                LOGGER.fine(() -> "no RunningTask associated with " + context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void remove(StepContext context) {
            RunningTasks holder;
            RunningTasks runningTasks = holder = (RunningTasks)ExtensionList.lookupSingleton(RunningTasks.class);
            synchronized (runningTasks) {
                if (holder.runningTasks.remove(context) == null) {
                    LOGGER.fine(() -> "no RunningTask to remove associated with " + context);
                }
            }
        }
    }

    private static final class RunningTask {
        @Nullable
        AsynchronousExecution execution;
        @Nullable
        Launcher launcher;
        boolean stopping;

        private RunningTask() {
        }
    }

    private static abstract class RetryableCauseOfInterruption
    extends CauseOfInterruption
    implements AgentErrorCondition.Retryable {
        private RetryableCauseOfInterruption() {
        }
    }

    public static final class RemovedNodeTimeoutCause
    extends RetryableCauseOfInterruption {
        public String getShortDescription() {
            return "Timeout waiting for agent to come back";
        }
    }

    public static final class RemovedNodeCause
    extends RetryableCauseOfInterruption {
        @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="deliberately mutable")
        public static boolean ENABLED = Boolean.parseBoolean(System.getProperty(ExecutorStepExecution.class.getName() + ".REMOVED_NODE_DETECTION", "true"));

        public String getShortDescription() {
            return "Agent was removed";
        }
    }

    @Extension
    public static final class RemovedNodeListener
    extends NodeListener {
        protected void onDeleted(@NonNull Node node) {
            if (!RemovedNodeCause.ENABLED) {
                return;
            }
            LOGGER.fine(() -> "received node deletion event on " + node.getNodeName());
            if (RemovedNodeListener.isOneShotAgent(node)) {
                LOGGER.fine(() -> "Cancelling owner run for one-shot agent " + node.getNodeName() + " immediately");
                RemovedNodeListener.cancelOwnerExecution(node, new RemovedNodeCause());
            } else {
                LOGGER.fine(() -> "Will cancel owner run for agent " + node.getNodeName() + " after waiting for " + TIMEOUT_WAITING_FOR_NODE_MILLIS + "ms");
                Timer.get().schedule(() -> RemovedNodeListener.cancelOwnerExecution(node, new RemovedNodeCause()), TIMEOUT_WAITING_FOR_NODE_MILLIS, TimeUnit.MILLISECONDS);
            }
        }

        private static boolean isOneShotAgent(Node node) {
            return node instanceof AbstractCloudSlave || node instanceof Slave && ((Slave)node).getRetentionStrategy() instanceof OnceRetentionStrategy;
        }

        private static void cancelOwnerExecution(Node node, CauseOfInterruption ... causes) {
            Computer c = node.toComputer();
            if (c == null || c.isOnline()) {
                LOGGER.fine(() -> "computer for " + node.getNodeName() + " was missing or online, skipping");
                return;
            }
            LOGGER.fine(() -> "processing node deletion event on " + node.getNodeName());
            for (hudson.model.Executor e : c.getExecutors()) {
                TaskListener listener;
                Queue.Executable exec = e.getCurrentExecutable();
                if (!(exec instanceof PlaceholderTask.PlaceholderExecutable)) continue;
                PlaceholderTask task = ((PlaceholderTask.PlaceholderExecutable)exec).getParent();
                try {
                    listener = (TaskListener)task.context.get(TaskListener.class);
                }
                catch (Exception x) {
                    LOGGER.log(Level.FINE, x, () -> task.getFullDisplayName() + " possibly already finished");
                    continue;
                }
                task.withExecution(execution -> {
                    BodyExecution body = execution.body;
                    if (body == null) {
                        listener.getLogger().println("Agent " + node.getNodeName() + " was deleted, but do not have a node body to cancel");
                        return;
                    }
                    listener.getLogger().println("Agent " + node.getNodeName() + " was deleted; cancelling node body");
                    body.cancel((Throwable)new FlowInterruptedException(Result.ABORTED, false, causes));
                });
            }
        }
    }

    public static final class QueueTaskCancelled
    extends RetryableCauseOfInterruption {
        public String getShortDescription() {
            return Messages.ExecutorStepExecution_queue_task_cancelled();
        }
    }

    @Extension
    public static final class AnomalousStatus
    extends PeriodicWork {
        private Set<StepContext> anomalous = Set.of();

        public long getRecurrencePeriod() {
            return Duration.ofMinutes(5L).toMillis();
        }

        public long getInitialDelay() {
            return Duration.ofMinutes(7L).toMillis();
        }

        protected void doRun() throws Exception {
            LOGGER.fine("checking");
            HashSet<StepContext> knownTasks = new HashSet<StepContext>();
            for (Queue.Item item : Queue.getInstance().getItems()) {
                if (!(item.task instanceof PlaceholderTask)) continue;
                LOGGER.fine(() -> "pending " + item);
                knownTasks.add(((PlaceholderTask)item.task).context);
            }
            Jenkins j = Jenkins.getInstanceOrNull();
            if (j != null) {
                for (Computer c : j.getComputers()) {
                    for (hudson.model.Executor e : c.getExecutors()) {
                        Queue.Executable exec2 = e.getCurrentExecutable();
                        if (!(exec2 instanceof PlaceholderTask.PlaceholderExecutable)) continue;
                        LOGGER.fine(() -> "running " + exec2);
                        knownTasks.add(((PlaceholderTask.PlaceholderExecutable)exec2).getParent().context);
                    }
                }
            }
            HashSet<StepContext> newAnomalous = new HashSet<StepContext>();
            HashSet affectedNodes = new HashSet();
            StepExecution.acceptAll(ExecutorStepExecution.class, exec -> {
                StepContext ctx = exec.getContext();
                if (!knownTasks.contains(ctx)) {
                    LOGGER.warning(() -> "do not know about " + ctx);
                    if (this.anomalous.contains(ctx)) {
                        try {
                            ((TaskListener)ctx.get(TaskListener.class)).error("node block still appears to be neither running nor scheduled; cancelling");
                        }
                        catch (IOException | InterruptedException x) {
                            LOGGER.log(Level.WARNING, null, x);
                        }
                        ctx.onFailure((Throwable)new FlowInterruptedException(Result.ABORTED, false, new CauseOfInterruption[]{new QueueTaskCancelled()}));
                        if (exec.state != null) {
                            affectedNodes.add(exec.state.node);
                        }
                    } else {
                        newAnomalous.add(ctx);
                    }
                } else {
                    LOGGER.fine(() -> "know about " + ctx);
                }
            }).get();
            if (!affectedNodes.isEmpty()) {
                StepExecution.acceptAll(DurableTaskStep.Execution.class, exec -> {
                    if (affectedNodes.contains(exec.node)) {
                        StepContext ctx = exec.getContext();
                        try {
                            ((TaskListener)ctx.get(TaskListener.class)).error("also cancelling shell steps running on " + exec.node);
                        }
                        catch (IOException | InterruptedException x) {
                            LOGGER.log(Level.WARNING, null, x);
                        }
                        ctx.onFailure((Throwable)new FlowInterruptedException(Result.ABORTED, false, new CauseOfInterruption[]{new RemovedNodeCause()}));
                    }
                });
            }
            for (StepContext ctx : newAnomalous) {
                ((TaskListener)ctx.get(TaskListener.class)).error("node block appears to be neither running nor scheduled; will cancel if this condition persists");
            }
            LOGGER.fine(() -> "done checking: " + this.anomalous + " \u2192 " + newAnomalous);
            this.anomalous = newAnomalous;
        }
    }

    @Extension
    public static class CancelledItemListener
    extends QueueListener {
        public void onLeft(Queue.LeftItem li) {
            if (li.isCancelled() && li.task instanceof PlaceholderTask) {
                PlaceholderTask task = (PlaceholderTask)li.task;
                if (!RunningTasks.get(task.context, t -> t.stopping, () -> false).booleanValue()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, null, new Throwable(li.task + " was cancelled"));
                    }
                    task.context.onFailure((Throwable)new FlowInterruptedException(Result.ABORTED, true, new CauseOfInterruption[]{new QueueTaskCancelled()}));
                }
            }
        }
    }
}

