/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps.scm;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MultiSCMRevisionState
extends SCMRevisionState {
    private final Map<String, SCMRevisionState> revisionStates = new HashMap<String, SCMRevisionState>();

    MultiSCMRevisionState() {
    }

    public void add(@NonNull SCM scm, @NonNull SCMRevisionState scmState) {
        String key = scm.getKey();
        SCMRevisionState old = this.revisionStates.put(key, scmState);
        if (old != null) {
            Logger.getLogger(MultiSCMRevisionState.class.getName()).log(Level.FINE, "overriding old revision state {0} from {1}", new Object[]{old, key});
        }
    }

    public SCMRevisionState get(@NonNull SCM scm) {
        return this.revisionStates.get(scm.getKey());
    }

    public String toString() {
        return "MultiSCMRevisionState" + String.valueOf(this.revisionStates);
    }
}

