/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public abstract class StepDescriptor
extends Descriptor<Step> {
    private static final Logger LOGGER = Logger.getLogger(StepDescriptor.class.getName());

    public abstract Set<? extends Class<?>> getRequiredContext();

    public Set<? extends Class<?>> getProvidedContext() {
        return Collections.emptySet();
    }

    public abstract String getFunctionName();

    public boolean takesImplicitBlockArgument() {
        return false;
    }

    public boolean isAdvanced() {
        return false;
    }

    public boolean isMetaStep() {
        return false;
    }

    @Nullable
    public final Class<?> getMetaStepArgumentType() {
        if (!this.isMetaStep()) {
            return null;
        }
        DescribableModel m = new DescribableModel(this.clazz);
        DescribableParameter p = m.getFirstRequiredParameter();
        if (p == null) {
            LOGGER.log(Level.WARNING, "{0} claims to be a meta-step but it has no parameter in @DataBoundConstructor", ((Object)((Object)this)).getClass().getName());
            return Void.TYPE;
        }
        return p.getErasedType();
    }

    @Deprecated
    public Step newInstance(Map<String, Object> arguments) throws Exception {
        return (Step)((Object)new DescribableModel(this.clazz).instantiate(arguments));
    }

    @Deprecated
    public Map<String, Object> defineArguments(Step step) throws UnsupportedOperationException {
        if (Util.isOverridden(StepDescriptor.class, ((Object)((Object)this)).getClass(), (String)"uninstantiate", (Class[])new Class[]{Step.class})) {
            return this.uninstantiate(step).toMap();
        }
        return DescribableModel.uninstantiate_((Object)((Object)step));
    }

    @Deprecated
    public UninstantiatedDescribable uninstantiate(Step step) throws UnsupportedOperationException {
        if (Util.isOverridden(StepDescriptor.class, ((Object)((Object)this)).getClass(), (String)"uninstantiate", (Class[])new Class[]{Step.class})) {
            return new UninstantiatedDescribable(this.defineArguments(step));
        }
        return DescribableModel.uninstantiate2_((Object)((Object)step));
    }

    public final void checkContextAvailability(StepContext c) throws MissingContextVariableException, IOException, InterruptedException {
        for (Class<?> type : this.getRequiredContext()) {
            Object v = c.get(type);
            if (v != null) continue;
            throw new MissingContextVariableException(type, this);
        }
    }

    public static ExtensionList<StepDescriptor> all() {
        return ExtensionList.lookup(StepDescriptor.class);
    }

    public static Iterable<StepDescriptor> allMeta() {
        return Iterables.filter(StepDescriptor.all(), (Predicate)new Predicate<StepDescriptor>(){

            @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="all() will not return nulls")
            public boolean apply(StepDescriptor i) {
                Class<?> a = i.getMetaStepArgumentType();
                if (a != null) {
                    if (a.equals(Object.class) || a.equals(Void.TYPE)) {
                        LOGGER.log(Level.WARNING, "{0} claims to be a meta-step but has {1} as the parameter in @DataBoundConstructor", new Object[]{((Object)((Object)i)).getClass().getName(), a.getName()});
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Nullable
    public static StepDescriptor byFunctionName(String name) {
        for (StepDescriptor d : StepDescriptor.all()) {
            if (!d.getFunctionName().equals(name)) continue;
            return d;
        }
        return null;
    }

    @NonNull
    public static List<StepDescriptor> metaStepsOf(String symbol) {
        ArrayList<StepDescriptor> r = new ArrayList<StepDescriptor>();
        for (StepDescriptor d : StepDescriptor.allMeta()) {
            Class<?> a = d.getMetaStepArgumentType();
            if (a == null || SymbolLookup.get().findDescriptor(a, symbol) == null) continue;
            r.add(d);
        }
        return r;
    }

    static boolean isAbleToUseToStringForDisplay(@CheckForNull Object o) {
        return o instanceof CharSequence || o instanceof Number || o instanceof Boolean || o instanceof Enum;
    }

    @CheckForNull
    public String argumentsToString(@NonNull Map<String, Object> namedArgs) {
        if (namedArgs.size() == 1) {
            Object val = namedArgs.values().iterator().next();
            return StepDescriptor.isAbleToUseToStringForDisplay(val) ? val.toString() : null;
        }
        return null;
    }
}

