/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.TaskListener;
import java.io.IOException;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.plugins.workflow.actions.FlowNodeAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.support.actions.LogActionImpl;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class LogStorageAction
extends LogAction
implements FlowNodeAction,
PersistentAction {
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO clean up")
    public transient FlowNode node;

    private LogStorageAction(FlowNode node) {
        this.node = node;
    }

    public void onLoad(FlowNode node) {
        this.node = node;
    }

    public AnnotatedLargeText<? extends FlowNode> getLogText() {
        FlowExecutionOwner owner = this.node.getExecution().getOwner();
        return LogStorage.of((FlowExecutionOwner)owner).stepLog(this.node, !this.node.isActive());
    }

    @Restricted(value={DoNotUse.class})
    public void writeLogTo(long offset, XMLOutput out) throws IOException {
        long pos2;
        long pos = offset;
        while ((pos2 = this.getLogText().writeHtmlTo(pos, out.asWriter())) > pos) {
            pos = pos2;
        }
    }

    @NonNull
    public static TaskListener listenerFor(@NonNull FlowNode node, @CheckForNull TaskListenerDecorator decorator) throws IOException, InterruptedException {
        FlowExecutionOwner owner = node.getExecution().getOwner();
        if (LogActionImpl.isOld(owner) || node.getAction(LogActionImpl.class) != null) {
            return LogActionImpl.stream(node, decorator);
        }
        if (node.getAction(LogStorageAction.class) == null) {
            node.addAction((Action)new LogStorageAction(node));
        }
        return TaskListenerDecorator.apply((TaskListener)LogStorage.of((FlowExecutionOwner)owner).nodeListener(node), (FlowExecutionOwner)owner, (TaskListenerDecorator)decorator);
    }
}

