/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jenkinsci.plugins.workflow.support.concurrent.MoreExecutors;

@Deprecated
class ChainingListenableFuture<I, O>
extends AbstractFuture<O>
implements Runnable {
    private AsyncFunction<? super I, ? extends O> function;
    private ListenableFuture<? extends I> inputFuture;
    private volatile ListenableFuture<? extends O> outputFuture;
    private final BlockingQueue<Boolean> mayInterruptIfRunningChannel = new LinkedBlockingQueue<Boolean>(1);
    private final CountDownLatch outputCreated = new CountDownLatch(1);

    ChainingListenableFuture(AsyncFunction<? super I, ? extends O> function, ListenableFuture<? extends I> inputFuture) {
        this.function = (AsyncFunction)Preconditions.checkNotNull(function);
        this.inputFuture = (ListenableFuture)Preconditions.checkNotNull(inputFuture);
    }

    public O get() throws InterruptedException, ExecutionException {
        if (!this.isDone()) {
            ListenableFuture<? extends I> inputFuture = this.inputFuture;
            if (inputFuture != null) {
                inputFuture.get();
            }
            this.outputCreated.await();
            ListenableFuture<? extends O> outputFuture = this.outputFuture;
            if (outputFuture != null) {
                outputFuture.get();
            }
        }
        return (O)super.get();
    }

    public O get(long timeout, TimeUnit unit) throws TimeoutException, ExecutionException, InterruptedException {
        if (!this.isDone()) {
            long start;
            ListenableFuture<? extends I> inputFuture;
            if (unit != TimeUnit.NANOSECONDS) {
                timeout = TimeUnit.NANOSECONDS.convert(timeout, unit);
                unit = TimeUnit.NANOSECONDS;
            }
            if ((inputFuture = this.inputFuture) != null) {
                start = System.nanoTime();
                inputFuture.get(timeout, unit);
                timeout -= Math.max(0L, System.nanoTime() - start);
            }
            start = System.nanoTime();
            if (!this.outputCreated.await(timeout, unit)) {
                throw new TimeoutException();
            }
            timeout -= Math.max(0L, System.nanoTime() - start);
            ListenableFuture<? extends O> outputFuture = this.outputFuture;
            if (outputFuture != null) {
                outputFuture.get(timeout, unit);
            }
        }
        return (O)super.get(timeout, unit);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            Uninterruptibles.putUninterruptibly(this.mayInterruptIfRunningChannel, (Object)mayInterruptIfRunning);
            this.cancel((Future<?>)this.inputFuture, mayInterruptIfRunning);
            this.cancel((Future<?>)this.outputFuture, mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    private void cancel(@Nullable Future<?> future, boolean mayInterruptIfRunning) {
        if (future != null) {
            future.cancel(mayInterruptIfRunning);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block16: {
            try {
                Object sourceResult;
                try {
                    sourceResult = Uninterruptibles.getUninterruptibly(this.inputFuture);
                }
                catch (CancellationException e) {
                    this.cancel(false);
                    this.function = null;
                    this.inputFuture = null;
                    this.outputCreated.countDown();
                    return;
                }
                catch (ExecutionException e) {
                    this.setException(e.getCause());
                    this.function = null;
                    this.inputFuture = null;
                    this.outputCreated.countDown();
                    return;
                }
                final ListenableFuture outputFuture = this.outputFuture = this.function.apply(sourceResult);
                if (this.isCancelled()) {
                    outputFuture.cancel(((Boolean)Uninterruptibles.takeUninterruptibly(this.mayInterruptIfRunningChannel)).booleanValue());
                    this.outputFuture = null;
                    return;
                }
                outputFuture.addListener(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ChainingListenableFuture.this.set(Uninterruptibles.getUninterruptibly((Future)outputFuture));
                        }
                        catch (CancellationException e) {
                            ChainingListenableFuture.this.cancel(false);
                            return;
                        }
                        catch (ExecutionException e) {
                            ChainingListenableFuture.this.setException(e.getCause());
                        }
                        finally {
                            ChainingListenableFuture.this.outputFuture = null;
                        }
                    }
                }, MoreExecutors.directExecutor());
                break block16;
                {
                    catch (UndeclaredThrowableException e) {
                        this.setException(e.getCause());
                        break block16;
                    }
                    catch (Exception e) {
                        this.setException(e);
                        break block16;
                    }
                    catch (Error e) {
                        this.setException(e);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.function = null;
                this.inputFuture = null;
                this.outputCreated.countDown();
            }
        }
    }
}

