/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.Extension;
import hudson.util.Secret;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.pickles.SingleTypedPickleFactory;

public class SecretPickle
extends Pickle {
    private final String encryptedValue;

    private SecretPickle(Secret secret) {
        this.encryptedValue = secret.getEncryptedValue();
    }

    public ListenableFuture<?> rehydrate() {
        return Futures.immediateFuture(Secret.fromString((String)this.encryptedValue));
    }

    @Extension
    public static final class Factory
    extends SingleTypedPickleFactory<Secret> {
        @Override
        protected Pickle pickle(Secret secret) {
            return new SecretPickle(secret);
        }
    }
}

