/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles.serialization;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ChainingObjectResolver;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.DryOwner;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.PickleResolver;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class RiverReader
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(RiverReader.class.getName());
    private final File file;
    private final ClassLoader classLoader;
    private final FlowExecutionOwner owner;
    private ObjectResolver ownerResolver = new ObjectResolver(){

        public Object readResolve(Object replacement) {
            if (replacement instanceof DryOwner) {
                return RiverReader.this.owner;
            }
            return replacement;
        }

        public Object writeReplace(Object original) {
            throw new IllegalStateException();
        }
    };
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="intentionally not")
    @CheckForNull
    public static ObjectResolver customResolver = null;
    private InputStream in;

    public RiverReader(File f, ClassLoader classLoader, FlowExecutionOwner owner) throws IOException {
        this.file = f;
        this.classLoader = classLoader;
        this.owner = owner;
    }

    private int parseHeader(DataInputStream din) throws IOException {
        if (din.readLong() != 7330745437582215633L) {
            throw new IOException("Invalid stream header");
        }
        short v = din.readShort();
        if (v != 1) {
            throw new IOException("Unexpected stream version: " + v);
        }
        return din.readInt();
    }

    @Deprecated
    public ListenableFuture<Unmarshaller> restorePickles() throws IOException {
        return this.restorePickles(new ArrayList());
    }

    public ListenableFuture<Unmarshaller> restorePickles(Collection<ListenableFuture<?>> pickleFutures) throws IOException {
        this.in = this.openStreamAt(0);
        try {
            DataInputStream din = new DataInputStream(this.in);
            int offset = this.parseHeader(din);
            List<Pickle> pickles = this.readPickles(offset);
            PickleResolver evr = new PickleResolver(pickles, this.owner);
            MarshallingConfiguration config = new MarshallingConfiguration();
            config.setClassResolver((ClassResolver)new SimpleClassResolver(this.classLoader));
            config.setObjectResolver(this.combine(evr, this.ownerResolver));
            Unmarshaller eu = new RiverMarshallerFactory().createUnmarshaller(config);
            eu.start(Marshalling.createByteInput((InputStream)din));
            final SandboxedUnmarshaller sandboxed = new SandboxedUnmarshaller(eu);
            return Futures.transform(evr.rehydrate(pickleFutures), new Function<PickleResolver, Unmarshaller>(){

                public Unmarshaller apply(PickleResolver input) {
                    return sandboxed;
                }
            });
        }
        catch (IOException x) {
            this.in.close();
            throw x;
        }
    }

    /*
     * Exception decompiling
     */
    private List<Pickle> readPickles(int offset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BufferedInputStream openStreamAt(int offset) throws IOException {
        FileInputStream in = new FileInputStream(this.file);
        IOUtils.skipFully((InputStream)in, (long)offset);
        return new BufferedInputStream(in);
    }

    private ObjectResolver combine(ObjectResolver ... resolvers) {
        ArrayList<ObjectResolver> _resolvers = new ArrayList<ObjectResolver>();
        Collections.addAll(_resolvers, resolvers);
        if (customResolver != null) {
            _resolvers.add(0, customResolver);
        }
        return _resolvers.size() == 1 ? (ObjectResolver)_resolvers.get(0) : new ChainingObjectResolver(_resolvers);
    }

    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "could not close stream on " + String.valueOf(this.file), x);
            }
        }
    }

    private static final class SandboxedUnmarshaller
    implements Unmarshaller {
        private final Unmarshaller delegate;

        SandboxedUnmarshaller(Unmarshaller delegate) {
            this.delegate = delegate;
        }

        private static <T> T sandbox(ReadSAM<T> lambda) throws ClassNotFoundException, IOException {
            try {
                return (T)GroovySandbox.runInSandbox(lambda::call, (Whitelist)Whitelist.all());
            }
            catch (ClassNotFoundException x) {
                throw x;
            }
            catch (IOException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new AssertionError((Object)x);
            }
        }

        public Object readObject() throws ClassNotFoundException, IOException {
            return SandboxedUnmarshaller.sandbox(() -> this.delegate.readObject());
        }

        public Object readObjectUnshared() throws ClassNotFoundException, IOException {
            return SandboxedUnmarshaller.sandbox(() -> ((Unmarshaller)this.delegate).readObjectUnshared());
        }

        public <T> T readObject(Class<T> type) throws ClassNotFoundException, IOException {
            return (T)SandboxedUnmarshaller.sandbox(() -> this.delegate.readObject(type));
        }

        public <T> T readObjectUnshared(Class<T> type) throws ClassNotFoundException, IOException {
            return (T)SandboxedUnmarshaller.sandbox(() -> this.delegate.readObjectUnshared(type));
        }

        public void start(ByteInput newInput) throws IOException {
            this.delegate.start(newInput);
        }

        public void clearInstanceCache() throws IOException {
            this.delegate.clearInstanceCache();
        }

        public void clearClassCache() throws IOException {
            this.delegate.clearClassCache();
        }

        public void finish() throws IOException {
            this.delegate.finish();
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public void readFully(byte[] b) throws IOException {
            this.delegate.readFully(b);
        }

        public void readFully(byte[] b, int off, int len) throws IOException {
            this.delegate.readFully(b, off, len);
        }

        public int skipBytes(int n) throws IOException {
            return this.delegate.skipBytes(n);
        }

        public boolean readBoolean() throws IOException {
            return this.delegate.readBoolean();
        }

        public byte readByte() throws IOException {
            return this.delegate.readByte();
        }

        public int readUnsignedByte() throws IOException {
            return this.delegate.readUnsignedByte();
        }

        public short readShort() throws IOException {
            return this.delegate.readShort();
        }

        public int readUnsignedShort() throws IOException {
            return this.delegate.readUnsignedShort();
        }

        public char readChar() throws IOException {
            return this.delegate.readChar();
        }

        public int readInt() throws IOException {
            return this.delegate.readInt();
        }

        public long readLong() throws IOException {
            return this.delegate.readLong();
        }

        public float readFloat() throws IOException {
            return this.delegate.readFloat();
        }

        public double readDouble() throws IOException {
            return this.delegate.readDouble();
        }

        public String readLine() throws IOException {
            return this.delegate.readLine();
        }

        public String readUTF() throws IOException {
            return this.delegate.readUTF();
        }

        @FunctionalInterface
        private static interface ReadSAM<T> {
            public T call() throws ClassNotFoundException, IOException;
        }
    }
}

