/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.input;

import hudson.Extension;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.HyperlinkNote;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public final class POSTHyperlinkNote
extends HyperlinkNote {
    private static final Logger LOGGER = Logger.getLogger(POSTHyperlinkNote.class.getName());
    private final String url;

    public static String encodeTo(String url, String text) {
        try {
            return new POSTHyperlinkNote(url, text.length()).encode() + text;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to serialize " + String.valueOf(POSTHyperlinkNote.class), e);
            return text;
        }
    }

    public POSTHyperlinkNote(String url, int length) {
        super("#", length);
        if (((String)url).startsWith("/")) {
            StaplerRequest2 req = Stapler.getCurrentRequest2();
            if (req != null) {
                url = req.getContextPath() + (String)url;
            } else {
                Jenkins j = Jenkins.getInstanceOrNull();
                if (j != null) {
                    String rootUrl = j.getRootUrl();
                    if (rootUrl != null) {
                        url = rootUrl + ((String)url).substring(1);
                    } else {
                        LOGGER.warning("You need to define the root URL of Jenkins");
                    }
                }
            }
        }
        this.url = url;
    }

    protected String extraAttributes() {
        return " data-encoded-url='" + POSTHyperlinkNote.encodeForJavascript(this.url) + "' class='post-hyperlink-note-button'";
    }

    private static String encodeForJavascript(String str) {
        String encode = URLEncoder.encode(str, StandardCharsets.UTF_8);
        return Base64.getUrlEncoder().encodeToString(encode.getBytes(StandardCharsets.UTF_8));
    }

    @Extension
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        public String getDisplayName() {
            return "POST Hyperlinks";
        }
    }
}

