/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xvfb;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class AutoDisplayNameFilterStream
extends FilterOutputStream {
    private final Semaphore received = new Semaphore(1);
    private final char[] lastLine = new char[1024];
    private int idx;
    private int displayNumber;
    private final long waitTime;

    protected AutoDisplayNameFilterStream(OutputStream decorated) {
        this(decorated, 30);
    }

    protected AutoDisplayNameFilterStream(OutputStream decorated, int waitTime) {
        super(decorated);
        this.waitTime = waitTime;
        try {
            this.received.acquire();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Unable to acquire semaphore upon creation", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.received.release();
        super.close();
    }

    public int getDisplayNumber() throws InterruptedException {
        if (this.received.tryAcquire(this.waitTime, TimeUnit.SECONDS)) {
            return this.displayNumber;
        }
        throw new IllegalStateException("No display name received from Xvfb within " + this.waitTime + " seconds");
    }

    @Override
    public void write(int ch) throws IOException {
        if (ch == 10 || ch == 13) {
            String line;
            if (this.idx != 0 && (line = new String(this.lastLine, 0, this.idx)).matches("\\d+")) {
                this.displayNumber = Integer.parseInt(line);
                this.received.release();
            }
            this.idx = 0;
        } else if (this.idx < this.lastLine.length - 1) {
            this.lastLine[this.idx++] = (char)ch;
        }
        super.write(ch);
    }
}

