/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xvfb;

import antlr.ANTLRException;
import com.google.common.base.Optional;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Items;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.model.listeners.RunListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.slaves.ComputerListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ProcessTree;
import hudson.util.XStream2;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.tasks.SimpleBuildWrapper;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.xvfb.AutoDisplayNameFilterStream;
import org.jenkinsci.plugins.xvfb.Messages;
import org.jenkinsci.plugins.xvfb.XvfbDisposer;
import org.jenkinsci.plugins.xvfb.XvfbEnvironment;
import org.jenkinsci.plugins.xvfb.XvfbEnvironmentConverter;
import org.jenkinsci.plugins.xvfb.XvfbInstallation;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class Xvfb
extends SimpleBuildWrapper {
    private static final String JENKINS_XVFB_COOKIE = "_JENKINS_XVFB_COOKIE";
    private static final String STDERR_FD = "2";
    @Extension
    public static final RunListener<Run> xvfbShutdownListener = new RunListener<Run>(){

        public void onCompleted(Run r, TaskListener listener) {
            XvfbEnvironment xvfbEnvironment = (XvfbEnvironment)r.getAction(XvfbEnvironment.class);
            if (xvfbEnvironment == null || !xvfbEnvironment.shutdownWithBuild) {
                return;
            }
            try {
                Executor executor = r.getExecutor();
                if (executor == null) {
                    return;
                }
                Computer computer = executor.getOwner();
                Node node = computer.getNode();
                if (node == null) {
                    return;
                }
                Launcher launcher = node.createLauncher(listener);
                Xvfb.shutdownAndCleanup(xvfbEnvironment, launcher, listener);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final Map<String, List<XvfbEnvironment>> zombies = Xvfb.createOrLoadZombiesMap();
    @Extension
    public static final ComputerListener nodeListener = new ComputerListener(){

        public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
            List zombiesAtComputer = (List)zombies.get(c.getName());
            if (zombiesAtComputer == null) {
                return;
            }
            ArrayList<XvfbEnvironment> slained = new ArrayList<XvfbEnvironment>();
            for (XvfbEnvironment zombie : zombiesAtComputer) {
                Xvfb.shutdownAndCleanupZombie(channel, zombie, listener);
                slained.add(zombie);
            }
            zombiesAtComputer.removeAll(slained);
        }
    };
    private static final int MILLIS_IN_SECOND = 1000;
    static final String DEFAULT_SCREEN = "1024x768x24";
    private String installationName;
    private Integer displayName;
    private String screen = "1024x768x24";
    private boolean debug = false;
    private long timeout = 1L;
    private int displayNameOffset = 1;
    private String additionalOptions;
    private boolean shutdownWithBuild = false;
    private boolean autoDisplayName = false;
    private String assignedLabels;
    private boolean parallelBuild = false;

    private static ConcurrentHashMap<String, List<XvfbEnvironment>> createOrLoadZombiesMap() {
        Jenkins.XSTREAM.registerConverter((Converter)new XvfbEnvironmentConverter());
        XmlFile fileOfZombies = Xvfb.zombiesFile();
        if (fileOfZombies.exists()) {
            try {
                ConcurrentHashMap oldZombies;
                ConcurrentHashMap concurrentHashMap = oldZombies = (ConcurrentHashMap)fileOfZombies.read();
                return concurrentHashMap;
            }
            catch (IOException iOException) {
            }
            finally {
                fileOfZombies.delete();
            }
        }
        return new ConcurrentHashMap<String, List<XvfbEnvironment>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdownAndCleanup(XvfbEnvironment xvfbEnvironment, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println(Messages.XvfbBuildWrapper_Stopping());
        try {
            launcher.kill(Collections.singletonMap(JENKINS_XVFB_COOKIE, xvfbEnvironment.cookie));
            FilePath frameBufferPath = new FilePath(launcher.getChannel(), xvfbEnvironment.frameBufferDir);
            frameBufferPath.deleteRecursive();
        }
        catch (ChannelClosedException e) {
            Map<String, List<XvfbEnvironment>> map = zombies;
            synchronized (map) {
                Computer currentComputer = Computer.currentComputer();
                String computerName = currentComputer.getName();
                List<XvfbEnvironment> zombiesAtComputer = zombies.get(computerName);
                if (zombiesAtComputer == null) {
                    zombiesAtComputer = new CopyOnWriteArrayList<XvfbEnvironment>();
                    zombies.put(computerName, zombiesAtComputer);
                }
                zombiesAtComputer.add(new XvfbEnvironment(xvfbEnvironment.cookie, xvfbEnvironment.frameBufferDir, xvfbEnvironment.displayName, false));
                XmlFile fileOfZombies = Xvfb.zombiesFile();
                fileOfZombies.write(zombies);
            }
        }
    }

    private static void shutdownAndCleanupZombie(Channel channel, final XvfbEnvironment zombie, TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println(Messages.XvfbBuildWrapper_KillingZombies(zombie.displayName, zombie.frameBufferDir));
        try {
            channel.call((Callable)new MasterToSlaveCallable<Void, InterruptedException>(){
                private static final long serialVersionUID = 1L;

                public Void call() throws InterruptedException {
                    ProcessTree processTree = ProcessTree.get();
                    for (ProcessTree.OSProcess osProcess : processTree) {
                        EnvVars environment = osProcess.getEnvironmentVariables();
                        String processCookie = (String)environment.get((Object)Xvfb.JENKINS_XVFB_COOKIE);
                        if (processCookie == null || !processCookie.equals(zombie.cookie)) continue;
                        osProcess.kill();
                        File zombieDir = new File(zombie.frameBufferDir);
                        if (zombieDir.delete()) continue;
                        zombieDir.deleteOnExit();
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            listener.getLogger().println(Messages.XvfbBuildWrapper_ZombieSlainFailed());
            e.printStackTrace(listener.getLogger());
        }
    }

    private static XmlFile zombiesFile() {
        return new XmlFile(Jenkins.XSTREAM, new File(Jenkins.get().getRootDir(), XvfbEnvironment.class.getName() + "-zombies.xml"));
    }

    @DataBoundConstructor
    public Xvfb() {
    }

    protected ArgumentListBuilder createCommandArguments(XvfbInstallation installation, FilePath frameBufferDir, int displayNameUsed) {
        String path = installation.getHome();
        ArgumentListBuilder cmd = "".equals(path) ? new ArgumentListBuilder(new String[]{"Xvfb"}) : new ArgumentListBuilder(new String[]{path + "/Xvfb"});
        if (this.autoDisplayName) {
            cmd.add(new String[]{"-displayfd", STDERR_FD});
        } else {
            cmd.add(":" + displayNameUsed);
        }
        if (this.screen != null && !this.screen.trim().isEmpty()) {
            cmd.add("-screen").add("0").add(this.screen);
        }
        cmd.add("-fbdir").add((Object)frameBufferDir);
        if (this.additionalOptions != null) {
            cmd.addTokenized(this.additionalOptions);
        }
        return cmd;
    }

    public String getAdditionalOptions() {
        return this.additionalOptions;
    }

    public String getAssignedLabels() {
        return this.assignedLabels;
    }

    public XvfbBuildWrapperDescriptor getDescriptor() {
        return (XvfbBuildWrapperDescriptor)super.getDescriptor();
    }

    public Integer getDisplayName() {
        return this.displayName;
    }

    public int getDisplayNameOffset() {
        return this.displayNameOffset;
    }

    public XvfbInstallation getInstallation(EnvVars env, Node node, TaskListener listener) {
        XvfbInstallation[] installations = this.getDescriptor().getInstallations();
        if (this.installationName == null && installations.length == 1) {
            return installations[0];
        }
        String installationNameToUse = (String)Optional.fromNullable((Object)this.installationName).or((Object)"default");
        for (XvfbInstallation installation : installations) {
            if (!installationNameToUse.equals(installation.getName())) continue;
            try {
                return installation.forEnvironment(env).forNode(node, TaskListener.NULL);
            }
            catch (IOException e) {
                listener.fatalError("IOException while locating installation", new Object[]{e});
            }
            catch (InterruptedException e) {
                listener.fatalError("InterruptedException while locating installation", new Object[]{e});
            }
        }
        return null;
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public String getScreen() {
        return this.screen;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isAutoDisplayName() {
        return this.autoDisplayName;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isParallelBuild() {
        return this.parallelBuild;
    }

    public boolean isShutdownWithBuild() {
        return this.shutdownWithBuild;
    }

    private XvfbEnvironment launchXvfb(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        Computer currentComputer = workspace.toComputer();
        if (currentComputer == null) {
            throw new IllegalStateException("Unable to access workspace on a node running the build, cannot continue.");
        }
        int displayNameUsed = this.determineDisplayName(run, currentComputer);
        Node currentNode = currentComputer.getNode();
        if (currentNode == null) {
            throw new IllegalStateException("Node is being removed, cannot continue");
        }
        if (!workspace.exists()) {
            workspace.mkdirs();
        }
        FilePath frameBufferDir = workspace.createTempDir(".xvfb-" + run.getId() + "-", ".fbdir");
        EnvVars environment = currentComputer.getEnvironment();
        XvfbInstallation installation = this.getInstallation(environment, currentNode, listener);
        if (installation == null) {
            listener.error(Messages.XvfbBuildWrapper_NoInstallationsConfigured());
            throw new Run.RunnerAbortedException();
        }
        ArgumentListBuilder cmd = this.createCommandArguments(installation, frameBufferDir, displayNameUsed);
        Launcher.ProcStarter procStarter = launcher.launch().cmds(cmd);
        ByteArrayOutputStream stdoutStream = new ByteArrayOutputStream();
        OutputStream stdout = this.debug ? listener.getLogger() : stdoutStream;
        ByteArrayOutputStream stderrStream = new ByteArrayOutputStream();
        AutoDisplayNameFilterStream stderr = new AutoDisplayNameFilterStream(this.debug ? listener.getLogger() : stderrStream);
        listener.getLogger().print(Messages.XvfbBuildWrapper_Starting());
        procStarter.stdout(stdout).stderr((OutputStream)stderr);
        String cookie = UUID.randomUUID().toString();
        procStarter.envs(Collections.singletonMap(JENKINS_XVFB_COOKIE, cookie));
        Proc process = procStarter.start();
        Thread.sleep(this.timeout * 1000L);
        if (!process.isAlive()) {
            if (!this.debug) {
                listener.getLogger().write(stdoutStream.toByteArray());
                listener.getLogger().write(stderrStream.toByteArray());
            }
            listener.getLogger().println();
            listener.error(Messages.XvfbBuildWrapper_FailedToStart());
            throw new Run.RunnerAbortedException();
        }
        if (this.autoDisplayName) {
            displayNameUsed = stderr.getDisplayNumber();
        }
        XvfbEnvironment xvfbEnvironment = new XvfbEnvironment(cookie, frameBufferDir.getRemote(), displayNameUsed, this.shutdownWithBuild);
        return xvfbEnvironment;
    }

    private int determineDisplayName(Run<?, ?> run, Computer currentComputer) {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.autoDisplayName) {
            return -1;
        }
        Executor executor = run.getExecutor();
        if (executor == null) {
            throw new IllegalStateException("Invoked outside of build: executor of the run is null");
        }
        int executorNumber = executor.getNumber();
        if (this.parallelBuild) {
            Computer[] computers = Jenkins.get().getComputers();
            int nodeIndex = Arrays.binarySearch(computers, currentComputer, ComputerNameComparator.INSTANCE);
            return nodeIndex * 100 + executorNumber + this.displayNameOffset;
        }
        return executorNumber + this.displayNameOffset;
    }

    @DataBoundSetter
    public void setAdditionalOptions(String additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    @DataBoundSetter
    public void setAssignedLabels(String assignedLabels) {
        this.assignedLabels = assignedLabels;
    }

    @DataBoundSetter
    public void setAutoDisplayName(boolean autoDisplayName) {
        this.autoDisplayName = autoDisplayName;
    }

    @DataBoundSetter
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @DataBoundSetter
    public void setDisplayName(Integer displayName) {
        this.displayName = displayName;
    }

    @DataBoundSetter
    public void setDisplayNameOffset(int displayNameOffset) {
        this.displayNameOffset = displayNameOffset;
    }

    @DataBoundSetter
    public void setInstallationName(String installationName) {
        this.installationName = installationName;
    }

    @DataBoundSetter
    public void setParallelBuild(boolean parallelBuild) {
        this.parallelBuild = parallelBuild;
    }

    @DataBoundSetter
    public void setScreen(String screen) {
        this.screen = screen;
    }

    @DataBoundSetter
    public void setShutdownWithBuild(boolean shutdownWithBuild) {
        this.shutdownWithBuild = shutdownWithBuild;
    }

    @DataBoundSetter
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        if (this.assignedLabels != null && !this.assignedLabels.trim().isEmpty()) {
            Label label;
            try {
                label = Label.parseExpression((String)this.assignedLabels);
            }
            catch (ANTLRException e) {
                throw new IOException(e);
            }
            Computer computer = Computer.currentComputer();
            Node node = computer.getNode();
            if (!label.matches(node)) {
                return;
            }
        }
        if (!launcher.isUnix()) {
            listener.getLogger().println(Messages.XvfbBuildWrapper_NotUnix());
            return;
        }
        Run<?, ?> rawRun = run;
        XvfbEnvironment xvfbEnvironment = this.launchXvfb(rawRun, workspace, launcher, listener);
        run.addAction((Action)xvfbEnvironment);
        context.env("DISPLAY", ":" + xvfbEnvironment.displayName);
        context.setDisposer((SimpleBuildWrapper.Disposer)new XvfbDisposer(xvfbEnvironment));
    }

    @Extension(ordinal=1.7976931348623157E308)
    public static class XvfbBuildWrapperDescriptor
    extends BuildWrapperDescriptor {
        private volatile XvfbInstallation[] installations = new XvfbInstallation[0];

        @Initializer(before=InitMilestone.PLUGINS_LISTED)
        public static void setupBackwardCompatibility() {
            XvfbBuildWrapperDescriptor.setupBackwardCompatibilityOn(Items.XSTREAM2);
            XStream xstream = new XmlFile(new File("mapping")).getXStream();
            if (xstream instanceof XStream2) {
                XvfbBuildWrapperDescriptor.setupBackwardCompatibilityOn((XStream2)xstream);
            }
        }

        private static void setupBackwardCompatibilityOn(XStream2 instance) {
            instance.addCompatibilityAlias("org.jenkinsci.plugins.xvfb.XvfbBuildWrapper", Xvfb.class);
            instance.addCompatibilityAlias("org.jenkinsci.plugins.xvfb.XvfbBuildWrapper$XvfbBuildWrapperDescriptor", XvfbBuildWrapperDescriptor.class);
        }

        public XvfbBuildWrapperDescriptor() {
            this.load();
        }

        public AutoCompletionCandidates doAutoCompleteAssignedLabels(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            Set labels = Jenkins.get().getLabels();
            for (Label label : labels) {
                if (value != null && !label.getName().startsWith(value)) continue;
                candidates.add(label.getName());
            }
            return candidates;
        }

        public FormValidation doCheckAssignedLabels(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) {
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.ok();
            }
            try {
                Label.parseExpression((String)value);
            }
            catch (ANTLRException e) {
                return FormValidation.error((Throwable)e, (String)Messages.XvfbBuildWrapper_AssignedLabelString_InvalidBooleanExpression(e.getMessage()));
            }
            Jenkins jenkins = Jenkins.get();
            Label label = jenkins.getLabel(value);
            if (label.isEmpty()) {
                for (LabelAtom labelAtom : label.listAtoms()) {
                    if (!labelAtom.isEmpty()) continue;
                    LabelAtom nearest = LabelAtom.findNearest((String)labelAtom.getName());
                    return FormValidation.warning((String)Messages.XvfbBuildWrapper_AssignedLabelString_NoMatch_DidYouMean(labelAtom.getName(), nearest.getDisplayName()));
                }
                return FormValidation.warning((String)Messages.XvfbBuildWrapper_AssignedLabelString_NoMatch());
            }
            return FormValidation.okWithMarkup((String)Messages.XvfbBuildWrapper_LabelLink(jenkins.getRootUrl(), label.getUrl(), label.getNodes().size() + label.getClouds().size()));
        }

        public FormValidation doCheckDisplayName(@QueryParameter String value) throws IOException {
            return this.validateOptionalNonNegativeInteger(value);
        }

        public FormValidation doCheckDisplayNameOffset(@QueryParameter String value) throws IOException {
            return this.validateOptionalPositiveInteger(value);
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) throws IOException {
            return this.validateOptionalNonNegativeInteger(value);
        }

        protected XmlFile getConfigFile() {
            File newConfigurationFile;
            File rootDir = Jenkins.get().getRootDir();
            File legacyConfiguration = new File(rootDir, "org.jenkinsci.plugins.xvfb.XvfbBuildWrapper.xml");
            if (legacyConfiguration.exists() && !legacyConfiguration.renameTo(newConfigurationFile = new File(rootDir, this.getId() + ".xml"))) {
                throw new IllegalStateException("Unable to rename legacy configuration file at " + legacyConfiguration + " to " + newConfigurationFile);
            }
            return super.getConfigFile();
        }

        public String getDisplayName() {
            return Messages.XvfbBuildWrapper_DisplayName();
        }

        public XvfbInstallation[] getInstallations() {
            return (XvfbInstallation[])this.installations.clone();
        }

        public XvfbInstallation.DescriptorImpl getToolDescriptor() {
            return (XvfbInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(XvfbInstallation.DescriptorImpl.class));
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (BuildWrapper)req.bindJSON(Xvfb.class, formData);
        }

        public void setInstallations(XvfbInstallation ... installations) {
            this.installations = installations == null ? new XvfbInstallation[0] : installations;
            this.save();
        }

        private FormValidation validateOptionalNonNegativeInteger(String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        private FormValidation validateOptionalPositiveInteger(String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            return FormValidation.validatePositiveInteger((String)value);
        }
    }

    private static final class ComputerNameComparator
    implements Comparator<Computer> {
        private static final ComputerNameComparator INSTANCE = new ComputerNameComparator();

        private ComputerNameComparator() {
        }

        @Override
        public int compare(Computer left, Computer right) {
            return left.getName().compareTo(right.getName());
        }
    }
}

