/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xvfb;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jenkinsci.plugins.xvfb.XvfbEnvironment;

public class XvfbEnvironmentConverter
implements Converter {
    private static final String COOKIE = "cookie";
    private static final String REMOTE_FRAME_BUFFER_DIR_ATTR = "remoteFrameBufferDir";
    private static final String DISPLAY_NAME_USED_ATTR = "displayNameUsed";

    public boolean canConvert(Class type) {
        return type != null && XvfbEnvironment.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        XvfbEnvironment xvfbEnvironment = (XvfbEnvironment)source;
        writer.addAttribute(COOKIE, xvfbEnvironment.cookie);
        writer.addAttribute(DISPLAY_NAME_USED_ATTR, String.valueOf(xvfbEnvironment.displayName));
        writer.addAttribute(REMOTE_FRAME_BUFFER_DIR_ATTR, xvfbEnvironment.frameBufferDir);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String cookie = reader.getAttribute(COOKIE);
        String frameBufferDir = reader.getAttribute(REMOTE_FRAME_BUFFER_DIR_ATTR);
        int displayNameUsed = Integer.parseInt(reader.getAttribute(DISPLAY_NAME_USED_ATTR));
        XvfbEnvironment xvfbEnvironment = new XvfbEnvironment(cookie, frameBufferDir, displayNameUsed, false);
        return xvfbEnvironment;
    }
}

