/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xvfb;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.xvfb.Messages;
import org.jenkinsci.plugins.xvfb.Xvfb;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class XvfbInstallation
extends ToolInstallation
implements NodeSpecific<XvfbInstallation>,
EnvironmentSpecific<XvfbInstallation> {
    @DataBoundConstructor
    public XvfbInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public XvfbInstallation forEnvironment(EnvVars environment) {
        return new XvfbInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public XvfbInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new XvfbInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    @Extension
    @Symbol(value={"xvfb"})
    public static class DescriptorImpl
    extends ToolDescriptor<XvfbInstallation> {
        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            List boundList = req.bindJSONToList(XvfbInstallation.class, json.get("tool"));
            this.setInstallations(boundList.toArray(new XvfbInstallation[boundList.size()]));
            return true;
        }

        public FormValidation doCheckHome(@QueryParameter File value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            if ("".equals(value.getPath())) {
                return FormValidation.ok();
            }
            if (!value.isDirectory()) {
                return FormValidation.error((String)Messages.XvfbInstallation_HomeNotDirectory(value));
            }
            File xvfbExecutable = new File(value, "Xvfb");
            if (!xvfbExecutable.exists()) {
                return FormValidation.error((String)Messages.XvfbInstallation_HomeDoesntContainXvfb(value));
            }
            if (!xvfbExecutable.canExecute()) {
                return FormValidation.error((String)Messages.XvfbInstallation_XvfbIsNotExecutable(value));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public String getDisplayName() {
            return Messages.XvfbInstallation_DisplayName();
        }

        public XvfbInstallation[] getInstallations() {
            return ((Xvfb.XvfbBuildWrapperDescriptor)Jenkins.get().getDescriptorByType(Xvfb.XvfbBuildWrapperDescriptor.class)).getInstallations();
        }

        public DescriptorImpl getToolDescriptor() {
            return (DescriptorImpl)((Object)ToolInstallation.all().get(DescriptorImpl.class));
        }

        public void setInstallations(XvfbInstallation ... installations) {
            ((Xvfb.XvfbBuildWrapperDescriptor)Jenkins.get().getDescriptorByType(Xvfb.XvfbBuildWrapperDescriptor.class)).setInstallations(installations);
        }
    }
}

